/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.util;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.Bookshelf;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.PaintingType;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Potion;
import net.minecraft.resources.IResourceManager;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ModDimension;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class MCJsonUtils {
    @Nullable
    public static LootTable loadLootTable(LootTableManager lootManager, IResourceManager resourceManager, ResourceLocation name) throws IOException {
        JsonObject data = MCJsonUtils.loadLootTable(resourceManager, name);
        return ForgeHooks.loadLootTable((Gson)LootTableManager.field_186526_b, (ResourceLocation)name, (JsonObject)data, (boolean)true, (LootTableManager)lootManager);
    }

    @Nullable
    public static JsonObject loadLootTable(IResourceManager manager, ResourceLocation name) throws IOException {
        return MCJsonUtils.loadJson(LootTableManager.field_186526_b, manager, new ResourceLocation(name.func_110624_b(), "loot_tables/" + name.func_110623_a() + ".json"));
    }

    @Nullable
    public static JsonObject loadJson(Gson gson, IResourceManager manager, ResourceLocation name) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(manager.func_199002_a(name).func_199027_b(), StandardCharsets.UTF_8));){
            JsonObject jsonObject = (JsonObject)JSONUtils.func_193839_a((Gson)gson, (Reader)reader, JsonObject.class);
            return jsonObject;
        }
    }

    public static <T extends IForgeRegistryEntry<T>> T getRegistryEntry(JsonObject json, String memberName, IForgeRegistry<T> registry) {
        if (json.has(memberName)) {
            return MCJsonUtils.getRegistryEntry(json.get(memberName), memberName, registry);
        }
        throw new JsonSyntaxException("Missing required value " + memberName);
    }

    public static <T extends IForgeRegistryEntry<T>> T getRegistryEntry(JsonElement json, String memberName, IForgeRegistry<T> registry) {
        if (json == null) {
            throw new JsonSyntaxException("The property " + memberName + " is missing.");
        }
        if (json.isJsonPrimitive()) {
            String rawId = json.getAsString();
            ResourceLocation registryId = ResourceLocation.func_208304_a((String)rawId);
            if (registryId != null) {
                IForgeRegistryEntry registryEntry = registry.getValue(registryId);
                if (registryEntry != null) {
                    return (T)registryEntry;
                }
                throw new JsonSyntaxException("No entry found for id " + rawId);
            }
            throw new JsonSyntaxException("Registry id " + rawId + " for property " + memberName + " was not a valid format.");
        }
        throw new JsonSyntaxException("Expected " + memberName + " to be a JSON primitive. was " + JSONUtils.func_151222_d((JsonElement)json));
    }

    public static Block getBlock(JsonObject json, String memberName) {
        return (Block)MCJsonUtils.getRegistryEntry(json.get(memberName), memberName, ForgeRegistries.BLOCKS);
    }

    public static Fluid getFluid(JsonObject json, String memberName) {
        return (Fluid)MCJsonUtils.getRegistryEntry(json.get(memberName), memberName, ForgeRegistries.FLUIDS);
    }

    public static Item getItem(JsonObject json, String memberName) {
        return (Item)MCJsonUtils.getRegistryEntry(json.get(memberName), memberName, ForgeRegistries.ITEMS);
    }

    public static Effect getPotion(JsonObject json, String memberName) {
        return (Effect)MCJsonUtils.getRegistryEntry(json.get(memberName), memberName, ForgeRegistries.POTIONS);
    }

    public static Biome getBiome(JsonObject json, String memberName) {
        return (Biome)MCJsonUtils.getRegistryEntry(json.get(memberName), memberName, ForgeRegistries.BIOMES);
    }

    public static SoundEvent getSound(JsonObject json, String memberName) {
        return (SoundEvent)MCJsonUtils.getRegistryEntry(json.get(memberName), memberName, ForgeRegistries.SOUND_EVENTS);
    }

    public static Potion getPotionType(JsonObject json, String memberName) {
        return (Potion)MCJsonUtils.getRegistryEntry(json.get(memberName), memberName, ForgeRegistries.POTION_TYPES);
    }

    public static Enchantment getEnchantment(JsonObject json, String memberName) {
        return (Enchantment)MCJsonUtils.getRegistryEntry(json.get(memberName), memberName, ForgeRegistries.ENCHANTMENTS);
    }

    public static EntityType<?> getEntity(JsonObject json, String memberName) {
        return (EntityType)MCJsonUtils.getRegistryEntry(json.get(memberName), memberName, ForgeRegistries.ENTITIES);
    }

    public static TileEntityType<?> getTileEntity(JsonObject json, String memberName) {
        return (TileEntityType)MCJsonUtils.getRegistryEntry(json.get(memberName), memberName, ForgeRegistries.TILE_ENTITIES);
    }

    public static ParticleType<?> getParticleType(JsonObject json, String memberName) {
        return (ParticleType)MCJsonUtils.getRegistryEntry(json.get(memberName), memberName, ForgeRegistries.PARTICLE_TYPES);
    }

    public static PaintingType getPainting(JsonObject json, String memberName) {
        return (PaintingType)MCJsonUtils.getRegistryEntry(json.get(memberName), memberName, ForgeRegistries.PAINTING_TYPES);
    }

    public static ModDimension getDimension(JsonObject json, String memberName) {
        return (ModDimension)MCJsonUtils.getRegistryEntry(json.get(memberName), memberName, ForgeRegistries.MOD_DIMENSIONS);
    }

    public static BlockState deserializeBlockState(JsonObject json) {
        Block block = MCJsonUtils.getBlock(json, "block");
        BlockState state = block.func_176223_P();
        if (json.has("properties")) {
            JsonElement propertiesElement = json.get("properties");
            if (propertiesElement.isJsonObject()) {
                JsonObject props = propertiesElement.getAsJsonObject();
                for (Map.Entry property : props.entrySet()) {
                    IProperty blockProperty = block.func_176194_O().func_185920_a((String)property.getKey());
                    if (blockProperty != null) {
                        if (((JsonElement)property.getValue()).isJsonPrimitive()) {
                            String valueString = ((JsonElement)property.getValue()).getAsString();
                            Optional propValue = blockProperty.func_185929_b(valueString);
                            if (propValue.isPresent()) {
                                try {
                                    state = (BlockState)state.func_206870_a(blockProperty, (Comparable)propValue.get());
                                }
                                catch (Exception e) {
                                    Bookshelf.LOG.error("Failed to update state for block {}. The mod that adds this block has issues.", (Object)block.getRegistryName());
                                    Bookshelf.LOG.catching((Throwable)e);
                                }
                                continue;
                            }
                            throw new JsonSyntaxException("The property " + (String)property.getKey() + " with value " + valueString + " coul not be parsed!");
                        }
                        throw new JsonSyntaxException("Expected property value for " + (String)property.getKey() + " to be primitive string. Got " + JSONUtils.func_151222_d((JsonElement)((JsonElement)property.getValue())));
                    }
                    throw new JsonSyntaxException("The property " + (String)property.getKey() + " is not valid for block " + block.getRegistryName());
                }
            } else {
                throw new JsonSyntaxException("Expected properties to be an object. Got " + JSONUtils.func_151222_d((JsonElement)propertiesElement));
            }
        }
        return state;
    }
}

