/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.util;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.Bookshelf;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public final class RecipeUtils {
    @Nullable
    public static RecipeManager getActiveRecipeManager() {
        return Bookshelf.SIDED.getActiveRecipeManager();
    }

    public static <T extends IRecipe<?>> Map<ResourceLocation, T> getRecipes(IRecipeType<T> recipeType, RecipeManager manager) {
        return manager.field_199522_d.getOrDefault(recipeType, Collections.emptyMap());
    }

    public static <T extends IRecipe<?>> List<T> getRecipeList(IRecipeType<T> recipeType, RecipeManager manager) {
        return RecipeUtils.getRecipeList(recipeType, manager, Comparator.comparing(recipe -> recipe.func_77571_b().func_77977_a()));
    }

    public static <T extends IRecipe<?>> List<T> getRecipeList(IRecipeType<T> recipeType, RecipeManager manager, Comparator<T> comparator) {
        return RecipeUtils.getRecipes(recipeType, manager).values().stream().sorted(comparator).collect(Collectors.toList());
    }

    public static <C extends IInventory, T extends IRecipe<C>> Map<ResourceLocation, IRecipe<C>> getRecipes(World world, IRecipeType<T> recipeType) {
        return RecipeUtils.getRecipes(world.func_199532_z(), recipeType);
    }

    public static <C extends IInventory, T extends IRecipe<C>> Map<ResourceLocation, IRecipe<C>> getRecipes(RecipeManager manager, IRecipeType<T> recipeType) {
        return manager.func_215366_a(recipeType);
    }
}

