/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.client.gui;

import com.alrex.parcool.ParCool;
import com.alrex.parcool.ParCoolConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiCheckBox;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ParCoolGuideScreen
extends GuiScreen {
    public static final ResourceLocation BACKGROUND_LOCATION = new ResourceLocation("parcool:textures/gui/book_background.png");
    private static final int PAGE_HOME = -1;
    private static final int PAGE_SETTINGS = -2;
    private static int currentPage = -1;
    private final List<String> pages = ParCoolGuideScreen.getPages();
    private final List<GuiButton> menuButtons = Arrays.asList(new GuiButton(0, 0, 0, 0, 0, "About This Mod"), new GuiButton(1, 0, 0, 0, 0, "Stamina"), new GuiButton(2, 0, 0, 0, 0, "CatLeap"), new GuiButton(3, 0, 0, 0, 0, "Crawl"), new GuiButton(4, 0, 0, 0, 0, "Dodge"), new GuiButton(5, 0, 0, 0, 0, "FastRunning"), new GuiButton(6, 0, 0, 0, 0, "GrabCliff"), new GuiButton(7, 0, 0, 0, 0, "Roll"), new GuiButton(8, 0, 0, 0, 0, "Vault"), new GuiButton(9, 0, 0, 0, 0, "WallJump"), new GuiButton(10, 0, 0, 0, 0, "Sliding"), new GuiButton(-2, 0, 0, 0, 0, "Settings"));
    private final List<GuiCheckBox> settingButtons;

    private void syncSettings() {
        List<GuiCheckBox> b = this.settingButtons;
        assert (b.size() == 9);
        ParCoolConfig.client.canCatLeap = b.get(0).isChecked();
        ParCoolConfig.client.canCrawl = b.get(1).isChecked();
        ParCoolConfig.client.canDodge = b.get(2).isChecked();
        ParCoolConfig.client.canFastRunning = b.get(3).isChecked();
        ParCoolConfig.client.canFrontFlip = b.get(4).isChecked();
        ParCoolConfig.client.canGrabCliff = b.get(5).isChecked();
        ParCoolConfig.client.canRoll = b.get(6).isChecked();
        ParCoolConfig.client.canVault = b.get(7).isChecked();
        ParCoolConfig.client.canWallJump = b.get(8).isChecked();
    }

    public ParCoolGuideScreen() {
        this.settingButtons = Arrays.asList(new GuiCheckBox(0, 0, 0, "CatLeap", ParCoolConfig.client.canCatLeap), new GuiCheckBox(0, 0, 0, "Crawl", ParCoolConfig.client.canCrawl), new GuiCheckBox(0, 0, 0, "Dodge", ParCoolConfig.client.canDodge), new GuiCheckBox(0, 0, 0, "FastRunning", ParCoolConfig.client.canFastRunning), new GuiCheckBox(0, 0, 0, "FrontFlip", ParCoolConfig.client.canFrontFlip), new GuiCheckBox(0, 0, 0, "GrabCliff", ParCoolConfig.client.canGrabCliff), new GuiCheckBox(0, 0, 0, "Roll", ParCoolConfig.client.canRoll), new GuiCheckBox(0, 0, 0, "Vault", ParCoolConfig.client.canVault), new GuiCheckBox(0, 0, 0, "WallJump", ParCoolConfig.client.canWallJump));
    }

    protected void func_73728_b(int p_73728_1_, int p_73728_2_, int p_73728_3_, int p_73728_4_) {
        super.func_73728_b(p_73728_1_, p_73728_2_, p_73728_3_, p_73728_4_);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTick) {
        super.func_73863_a(mouseX, mouseY, partialTick);
        Minecraft mc = this.field_146297_k;
        mc.func_110434_K().func_110577_a(BACKGROUND_LOCATION);
        ScaledResolution resolution = new ScaledResolution(mc);
        int width = 256;
        int height = (int)((double)width * 0.75);
        int offsetX = (resolution.func_78326_a() - width) / 2;
        int offsetY = (resolution.func_78328_b() - height) / 2;
        GuiUtils.drawContinuousTexturedBox((int)offsetX, (int)offsetY, (int)0, (int)0, (int)width, (int)height, (int)256, (int)192, (int)0, (float)0.0f);
        this.renderContent(offsetX, offsetY, width / 2, height, mouseX, mouseY, partialTick);
        this.renderMenu(offsetX + width / 2, offsetY, width / 2, height, mouseX, mouseY, partialTick);
    }

    public void func_73869_a(char p_73869_1_, int keyCode) {
        try {
            super.func_73869_a(p_73869_1_, keyCode);
        }
        catch (IOException e) {
            return;
        }
        this.syncSettings();
        switch (keyCode) {
            case 200: {
                this.changePage(currentPage - 1);
                break;
            }
            case 208: {
                this.changePage(currentPage + 1);
            }
        }
    }

    public void func_73864_a(int mouseX, int mouseY, int type) {
        if (type == 0) {
            if (currentPage == -2) {
                this.settingButtons.stream().filter(button -> {
                    int x = button.field_146128_h;
                    int y = button.field_146129_i;
                    int height = button.field_146121_g;
                    int width = button.func_146117_b();
                    return x < mouseX && mouseX < x + width && y < mouseY && mouseY < y + height;
                }).findFirst().ifPresent(button -> button.func_146116_c(this.field_146297_k, mouseX, mouseY));
            }
            this.menuButtons.stream().filter(button -> {
                int x = button.field_146128_h;
                int y = button.field_146129_i;
                int height = button.field_146121_g;
                int width = button.func_146117_b();
                return x < mouseX && mouseX < x + width && y < mouseY && mouseY < y + height;
            }).findFirst().ifPresent(this::onPress);
        }
    }

    private void renderContent(int left, int top, int width, int height, int mouseX, int mouseY, float n) {
        switch (currentPage) {
            case -1: {
                this.renderHome(left, top, width, height, mouseX, mouseY, n);
                break;
            }
            case -2: {
                this.renderSettings(left, top, width, height, mouseX, mouseY, n);
                break;
            }
            default: {
                this.renderContentText(left, top, width, height, mouseX, mouseY, n);
            }
        }
    }

    private void renderHome(int left, int top, int width, int height, int mouseX, int mouseY, float n) {
        Minecraft mc = this.field_146297_k;
        FontRenderer fontRenderer = this.field_146289_q;
        int offsetY = 20;
        int center = left + width / 2;
        String textTitle = "ParCool!";
        String textSubtitle = "Guide Book";
        this.drawCenteredText(textTitle, center, top + 20 + 10, ParCoolGuideScreen.getColorCodeFromARGB(255, 85, 85, 255));
        this.drawCenteredText(textSubtitle, center, top + 20 + 15 + fontRenderer.field_78288_b, ParCoolGuideScreen.getColorCodeFromARGB(255, 68, 68, 187));
    }

    private void renderContentText(int left, int top, int width, int height, int mouseX, int mouseY, float n) {
        Minecraft mc = this.field_146297_k;
        FontRenderer fontRenderer = this.field_146289_q;
        int offsetY = 20;
        int offsetX = 10;
        if (currentPage < 0 || this.pages.size() <= currentPage) {
            return;
        }
        String text = this.pages.get(currentPage);
        List wrappedLine = fontRenderer.func_78271_c(text, width - 20);
        for (int i = 0; i < wrappedLine.size(); ++i) {
            fontRenderer.func_78276_b((String)wrappedLine.get(i), left + 10, top + 20 + i * fontRenderer.field_78288_b + 3, ParCoolGuideScreen.getColorCodeFromARGB(255, 0, 0, 0));
        }
    }

    private void renderMenu(int left, int top, int width, int height, int mouseX, int mouseY, float n) {
        Minecraft mc = this.field_146297_k;
        FontRenderer fontRenderer = this.field_146289_q;
        int offsetY = 20;
        int offsetX = 20;
        int buttonWidth = width - offsetX * 2;
        int y = (int)((double)top + (double)offsetY * 1.5);
        this.drawCenteredText("Index", left + width / 2, top + offsetY, ParCoolGuideScreen.getColorCodeFromARGB(255, 102, 102, 255));
        for (GuiButton button : this.menuButtons) {
            button.func_175211_a(buttonWidth);
            button.field_146121_g = fontRenderer.field_78288_b + 2;
            button.field_146128_h = left + offsetX;
            button.field_146129_i = y;
            button.func_191745_a(mc, mouseX, mouseY, n);
            y += button.field_146121_g;
        }
    }

    private void renderSettings(int left, int top, int width, int height, int mouseX, int mouseY, float n) {
        Minecraft mc = this.field_146297_k;
        FontRenderer fontRenderer = this.field_146289_q;
        int offsetY = 20;
        int offsetX = 20;
        int buttonWidth = width - offsetX * 2;
        int y = (int)((double)top + (double)offsetY * 1.5);
        this.drawCenteredText("Enabled Actions", left + width / 2, top + offsetY, ParCoolGuideScreen.getColorCodeFromARGB(255, 102, 102, 255));
        for (GuiCheckBox button : this.settingButtons) {
            button.func_175211_a(buttonWidth);
            button.field_146121_g = fontRenderer.field_78288_b + 6;
            button.field_146128_h = left + offsetX;
            button.field_146129_i = y;
            button.func_191745_a(mc, mouseX, mouseY, n);
            y += button.field_146121_g;
        }
    }

    private void drawCenteredText(String text, int x, int y, int color) {
        FontRenderer fontRenderer = this.field_146289_q;
        int width = fontRenderer.func_78256_a(text);
        fontRenderer.func_78276_b(text, x - (width >> 1), y - (fontRenderer.field_78288_b >> 1), color);
    }

    private static int getColorCodeFromARGB(int a, int r, int g, int b) {
        return a * 0x1000000 + r * 65536 + g * 256 + b;
    }

    private static List<String> getPages() {
        String path = "/assets/parcool/book/parcoolGuide_content.txt";
        BufferedReader reader = new BufferedReader(new InputStreamReader(ParCool.class.getResourceAsStream("/assets/parcool/book/parcoolGuide_content.txt"), StandardCharsets.UTF_8));
        ArrayList<String> texts = new ArrayList<String>();
        Iterator iterator = reader.lines().iterator();
        Pattern division = Pattern.compile("===+");
        AtomicReference<StringBuilder> builder = new AtomicReference<StringBuilder>(new StringBuilder());
        iterator.forEachRemaining(line -> {
            if (!division.matcher((CharSequence)line).matches()) {
                ((StringBuilder)builder.get()).append((String)line).append("\n");
            } else {
                texts.add(builder.toString());
                if (iterator.hasNext()) {
                    builder.set(new StringBuilder());
                }
            }
        });
        return texts;
    }

    private void changePage(int i) {
        if (i != -1 && i != -2 && (i < 0 || this.pages.size() <= i)) {
            return;
        }
        currentPage = i;
    }

    private void onPress(GuiButton button) {
        this.changePage(button.field_146127_k);
    }

    private void openSetting(GuiButton button) {
        this.changePage(-2);
    }
}

