/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.client.hud;

import com.alrex.parcool.ParCoolConfig;
import com.alrex.parcool.common.capability.IStamina;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class StaminaHUD
extends Gui {
    public static void render(RenderGameOverlayEvent event) {
        if (!ParCoolConfig.client.ParCoolActivation) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        IStamina stamina = IStamina.get((EntityPlayer)player);
        if (stamina == null) {
            return;
        }
        ScaledResolution resolution = new ScaledResolution(Minecraft.func_71410_x());
        int width = resolution.func_78326_a();
        int height = resolution.func_78328_b();
        int boxWidth = 100;
        int boxHeight = 20;
        int heartWidth = 11;
        int staminaWidth = 78;
        int x = width - 100 - 1;
        int y = height - 20 - 1;
        double staminaScale = (double)stamina.getStamina() / (double)stamina.getMaxStamina();
        if (staminaScale < 0.0) {
            staminaScale = 0.0;
        }
        if (staminaScale > 1.0) {
            staminaScale = 1.0;
        }
        int color = StaminaHUD.getStaminaColor(staminaScale, stamina.isExhausted());
        GuiUtils.drawGradientRect((int)0, (int)x, (int)y, (int)(x + 100), (int)(y + 20), (int)-1722263980, (int)-1722263980);
        GuiUtils.drawGradientRect((int)0, (int)(x + 2), (int)(y + 2), (int)(x + 100 - 2), (int)(y + 20 - 2), (int)0x66898989, (int)0x66898989);
        GuiUtils.drawGradientRect((int)0, (int)(x + 11 + 7), (int)(y + 4), (int)(x + 11 + 7 + 78), (int)(y + 5 + 11), (int)-1725224149, (int)-1725224149);
        GuiUtils.drawGradientRect((int)0, (int)(x + 11 + 7), (int)(y + 4), (int)(x + 11 + 7 + (int)Math.round(78.0 * staminaScale)), (int)(y + 5 + 11), (int)color, (int)color);
        StaminaHUD.renderYellowHeart(x + 4, y + 5, 11, 11);
    }

    private static void renderYellowHeart(int x, int y, int width, int height) {
        Gui.func_152125_a((int)x, (int)y, (float)161.0f, (float)1.0f, (int)7, (int)7, (int)width, (int)height, (float)256.0f, (float)256.0f);
    }

    private static int getStaminaColor(double factor, boolean exhausted) {
        if (exhausted) {
            return -862372806;
        }
        if (factor > 0.5) {
            return StaminaHUD.getColorCodeFromARGB(204, (int)(255.0 * (1.0 - factor) * 2.0), 255, 0);
        }
        return StaminaHUD.getColorCodeFromARGB(204, 255, (int)(255.0 * (factor * 2.0)), 0);
    }

    private static int getColorCodeFromARGB(int a, int r, int g, int b) {
        return a * 0x1000000 + r * 65536 + g * 256 + b;
    }

    @SubscribeEvent
    public static void onOverlay(RenderGameOverlayEvent.Pre event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            return;
        }
        StaminaHUD.render((RenderGameOverlayEvent)event);
    }
}

