/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.capability.impl;

import com.alrex.parcool.ParCoolConfig;
import com.alrex.parcool.client.input.KeyBindings;
import com.alrex.parcool.client.input.KeyRecorder;
import com.alrex.parcool.common.capability.IGrabCliff;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.utilities.PlayerUtils;
import com.alrex.parcool.utilities.WorldUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GrabCliff
implements IGrabCliff {
    private boolean grabbing = false;
    private int grabbingTime = 0;
    private int notGrabbingTime = 0;

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canGrabCliff(EntityPlayer player) {
        IStamina stamina = IStamina.get(player);
        if (stamina == null) {
            return false;
        }
        double ySpeed = PlayerUtils.getVelocity((Entity)player).field_72448_b;
        return !stamina.isExhausted() && ySpeed < 0.2 && ParCoolConfig.client.canGrabCliff && KeyBindings.getKeyGrabWall().func_151470_d() && player.func_184614_ca().func_190926_b() && player.func_184592_cb().func_190926_b() && WorldUtil.existsGrabbableWall((EntityLivingBase)player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canJumpOnCliff(EntityPlayer player) {
        return this.grabbing && ParCoolConfig.client.canGrabCliff && this.grabbingTime > 3 && KeyRecorder.keyJumpState.isPressed();
    }

    @Override
    public boolean isGrabbing() {
        return this.grabbing;
    }

    @Override
    public void setGrabbing(boolean grabbing) {
        this.grabbing = grabbing;
    }

    @Override
    public int getGrabbingTime() {
        return this.grabbingTime;
    }

    @Override
    public int getNotGrabbingTime() {
        return this.notGrabbingTime;
    }

    @Override
    public void updateTime() {
        if (this.grabbing) {
            ++this.grabbingTime;
            this.notGrabbingTime = 0;
        } else {
            ++this.notGrabbingTime;
            this.grabbingTime = 0;
        }
    }

    @Override
    public int getStaminaConsumptionGrab() {
        return 4;
    }

    @Override
    public int getStaminaConsumptionClimbUp() {
        return 200;
    }
}

