/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.capability.impl;

import com.alrex.parcool.ParCoolConfig;
import com.alrex.parcool.common.capability.IStamina;

public class Stamina
implements IStamina {
    private static final int COOL_TIME = 20;
    private int stamina = this.getMaxStamina();
    private boolean exhausted = false;
    private int coolTime = 0;

    @Override
    public void setStamina(int stamina) {
        this.stamina = stamina;
    }

    @Override
    public int getStamina() {
        return this.stamina;
    }

    @Override
    public int getMaxStamina() {
        return ParCoolConfig.client.maxStamina;
    }

    @Override
    public void consume(int amount) {
        this.stamina -= amount;
        this.coolTime = 20;
        if (this.stamina <= 0) {
            this.stamina = 0;
            this.setExhausted(true);
        }
    }

    @Override
    public void recover(int amount) {
        if (this.coolTime > 0) {
            return;
        }
        this.stamina += amount;
        if (this.stamina >= this.getMaxStamina()) {
            this.stamina = this.getMaxStamina();
            this.setExhausted(false);
        }
    }

    @Override
    public void setExhausted(boolean exhausted) {
        this.exhausted = exhausted;
    }

    @Override
    public boolean isExhausted() {
        return this.exhausted;
    }

    @Override
    public void updateRecoveryCoolTime() {
        if (this.coolTime > 0) {
            --this.coolTime;
        }
    }

    @Override
    public int getRecoveryCoolTime() {
        return this.coolTime;
    }
}

