/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.event;

import com.alrex.parcool.ParCool;
import com.alrex.parcool.ParCoolConfig;
import com.alrex.parcool.client.input.KeyRecorder;
import com.alrex.parcool.client.particle.ParticleProvider;
import com.alrex.parcool.common.capability.ICatLeap;
import com.alrex.parcool.common.capability.ICrawl;
import com.alrex.parcool.common.capability.IDodge;
import com.alrex.parcool.common.capability.IFastRunning;
import com.alrex.parcool.common.capability.IGrabCliff;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.IVault;
import com.alrex.parcool.common.capability.IWallJump;
import com.alrex.parcool.common.network.SyncCatLeapMessage;
import com.alrex.parcool.common.network.SyncCrawlMessage;
import com.alrex.parcool.common.network.SyncDodgeMessage;
import com.alrex.parcool.common.network.SyncFastRunningMessage;
import com.alrex.parcool.common.network.SyncGrabCliffMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class EventActivateParCool {
    @SubscribeEvent
    public static void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (KeyRecorder.keyActivateParCoolState.isPressed()) {
            boolean can;
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (player == null) {
                return;
            }
            IStamina stamina = IStamina.get((EntityPlayer)player);
            if (stamina == null) {
                return;
            }
            if (stamina.isExhausted()) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("warning.activation.exhausted", new Object[0]), false);
                return;
            }
            boolean active = !ParCool.isActive();
            boolean bl = can = active ? EventActivateParCool.activate() : EventActivateParCool.inactivate();
            if (!can) {
                return;
            }
            ParCool.setActivation(active);
            player.func_146105_b((ITextComponent)new TextComponentTranslation(active ? "message.activation.active" : "message.activation.inactive", new Object[0]), false);
            ParCoolConfig.sync();
        }
    }

    public static boolean activate() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return false;
        }
        ParticleProvider.spawnEffectActivateParCool((EntityPlayer)player);
        return true;
    }

    public static boolean inactivate() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        ICatLeap catLeap = ICatLeap.get((EntityPlayer)player);
        ICrawl crawl = ICrawl.get((EntityPlayer)player);
        IFastRunning fastRunning = IFastRunning.get((EntityPlayer)player);
        IGrabCliff grabCliff = IGrabCliff.get((EntityPlayer)player);
        IVault vault = IVault.get((EntityPlayer)player);
        IDodge dodge = IDodge.get((EntityPlayer)player);
        IWallJump wallJump = IWallJump.get((EntityPlayer)player);
        if (catLeap == null || crawl == null || fastRunning == null || grabCliff == null || vault == null || dodge == null || wallJump == null) {
            return false;
        }
        catLeap.setReady(false);
        catLeap.setLeaping(false);
        crawl.setCrawling(false);
        crawl.setSliding(false);
        fastRunning.setFastRunning(false);
        grabCliff.setGrabbing(false);
        vault.setVaulting(false);
        dodge.setDodging(false);
        SyncCatLeapMessage.sync((EntityPlayer)player);
        SyncCrawlMessage.sync((EntityPlayer)player);
        SyncGrabCliffMessage.sync((EntityPlayer)player);
        SyncFastRunningMessage.sync((EntityPlayer)player);
        SyncDodgeMessage.sync((EntityPlayer)player);
        return true;
    }
}

