/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.network;

import com.alrex.parcool.ParCool;
import com.alrex.parcool.ParCoolConfig;
import com.alrex.parcool.constants.ActionsEnum;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class SetActionPossibilityMessage
implements IMessage,
IMessageHandler<SetActionPossibilityMessage, SetActionPossibilityMessage> {
    private ActionsEnum actionsEnum = null;
    private boolean possibility = false;

    public void toBytes(ByteBuf packet) {
        packet.writeBoolean(this.possibility);
        String name = this.actionsEnum.name();
        packet.writeInt(name.length());
        packet.writeCharSequence((CharSequence)name, StandardCharsets.US_ASCII);
    }

    public void fromBytes(ByteBuf packet) {
        this.possibility = packet.readBoolean();
        this.actionsEnum = ActionsEnum.valueOf(packet.readCharSequence(packet.readInt(), StandardCharsets.US_ASCII).toString());
    }

    public SetActionPossibilityMessage onMessage(SetActionPossibilityMessage message, MessageContext context) {
        Minecraft.func_71410_x().func_152344_a(() -> {
            if (context.side == Side.CLIENT) {
                ParCoolConfig.Client c = ParCoolConfig.client;
                switch (this.actionsEnum) {
                    case Crawl: {
                        c.canCrawl = this.possibility;
                        break;
                    }
                    case CatLeap: {
                        c.canCatLeap = this.possibility;
                        break;
                    }
                    case Dodge: {
                        c.canDodge = this.possibility;
                        break;
                    }
                    case FastRunning: {
                        c.canFastRunning = this.possibility;
                        break;
                    }
                    case Roll: {
                        c.canRoll = this.possibility;
                        break;
                    }
                    case Vault: {
                        c.canVault = this.possibility;
                        break;
                    }
                    case WallJump: {
                        c.canWallJump = this.possibility;
                        break;
                    }
                    case GrabCliff: {
                        c.canGrabCliff = this.possibility;
                    }
                }
                EntityPlayerSP entityPlayerSP = Minecraft.func_71410_x().field_71439_g;
            }
        });
        return null;
    }

    public static void send(EntityPlayerMP player, ActionsEnum actionsEnum, boolean possibility) {
        SetActionPossibilityMessage message = new SetActionPossibilityMessage();
        message.actionsEnum = actionsEnum;
        message.possibility = possibility;
        ParCool.CHANNEL_INSTANCE.sendTo((IMessage)message, player);
    }
}

