/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.network;

import com.alrex.parcool.ParCool;
import com.alrex.parcool.ParCoolConfig;
import com.alrex.parcool.common.capability.IRoll;
import com.alrex.parcool.common.processor.RollLogic;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class StartRollMessage
implements IMessage {
    private UUID playerID = null;

    public void toBytes(ByteBuf packet) {
        packet.writeLong(this.playerID.getMostSignificantBits());
        packet.writeLong(this.playerID.getLeastSignificantBits());
    }

    public void fromBytes(ByteBuf packet) {
        this.playerID = new UUID(packet.readLong(), packet.readLong());
    }

    public static void send(EntityPlayerMP player) {
        StartRollMessage message = new StartRollMessage();
        message.playerID = player.func_110124_au();
        ParCool.CHANNEL_INSTANCE.sendToAll((IMessage)message);
    }

    @SideOnly(value=Side.SERVER)
    public static class ServerHandler
    implements IMessageHandler<StartRollMessage, StartRollMessage> {
        public StartRollMessage onMessage(StartRollMessage message, MessageContext ctx) {
            return null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class ClientHandler
    implements IMessageHandler<StartRollMessage, StartRollMessage> {
        public StartRollMessage onMessage(StartRollMessage message, MessageContext context) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                if (context.side == Side.CLIENT) {
                    WorldClient world = Minecraft.func_71410_x().field_71441_e;
                    if (world == null) {
                        return;
                    }
                    EntityPlayer startPlayer = world.func_152378_a(message.playerID);
                    if (startPlayer == null) {
                        return;
                    }
                    IRoll roll = IRoll.get(startPlayer);
                    if (roll == null) {
                        return;
                    }
                    if (!ParCoolConfig.client.canRoll || !ParCoolConfig.client.ParCoolActivation) {
                        return;
                    }
                    if (startPlayer.func_175144_cb()) {
                        RollLogic.rollStart();
                    } else {
                        roll.setRollReady(false);
                        roll.setRolling(true);
                    }
                }
            });
            return null;
        }
    }
}

