/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.network;

import com.alrex.parcool.ParCool;
import com.alrex.parcool.common.capability.ICrawl;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SyncCrawlMessage
implements IMessage {
    private boolean isCrawling = false;
    private boolean isSliding = false;
    private UUID playerID = null;

    public void toBytes(ByteBuf packet) {
        packet.writeBoolean(this.isCrawling);
        packet.writeBoolean(this.isSliding);
        packet.writeLong(this.playerID.getMostSignificantBits());
        packet.writeLong(this.playerID.getLeastSignificantBits());
    }

    public void fromBytes(ByteBuf packet) {
        this.isCrawling = packet.readBoolean();
        this.isSliding = packet.readBoolean();
        this.playerID = new UUID(packet.readLong(), packet.readLong());
    }

    @SideOnly(value=Side.CLIENT)
    public static void sync(EntityPlayer player) {
        ICrawl crawl = ICrawl.get(player);
        SyncCrawlMessage message = new SyncCrawlMessage();
        message.isCrawling = crawl.isCrawling();
        message.isSliding = crawl.isSliding();
        message.playerID = player.func_110124_au();
        ParCool.CHANNEL_INSTANCE.sendToServer((IMessage)message);
    }

    @SideOnly(value=Side.CLIENT)
    public static class ClientHandler
    implements IMessageHandler<SyncCrawlMessage, SyncCrawlMessage> {
        public SyncCrawlMessage onMessage(SyncCrawlMessage message, MessageContext context) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                ICrawl crawl;
                EntityPlayerMP player;
                if (context.side == Side.CLIENT) {
                    WorldClient world = Minecraft.func_71410_x().field_71441_e;
                    if (world == null) {
                        return;
                    }
                    player = world.func_152378_a(message.playerID);
                    if (player == null || player.func_175144_cb()) {
                        return;
                    }
                } else {
                    player = context.getServerHandler().field_147369_b;
                    ParCool.CHANNEL_INSTANCE.sendToAll((IMessage)message);
                    if (player == null) {
                        return;
                    }
                }
                if ((crawl = ICrawl.get((EntityPlayer)player)) == null) {
                    return;
                }
                crawl.setCrawling(message.isCrawling);
                crawl.setSliding(message.isSliding);
            });
            return null;
        }
    }

    @SideOnly(value=Side.SERVER)
    public static class ServerHandler
    implements IMessageHandler<SyncCrawlMessage, SyncCrawlMessage> {
        public SyncCrawlMessage onMessage(SyncCrawlMessage message, MessageContext context) {
            EntityPlayerMP player = context.getServerHandler().field_147369_b;
            player.func_71121_q().func_152344_a(() -> {
                ParCool.CHANNEL_INSTANCE.sendToAll((IMessage)message);
                ICrawl crawl = ICrawl.get((EntityPlayer)player);
                if (crawl == null) {
                    return;
                }
                crawl.setCrawling(message.isCrawling);
                crawl.setSliding(message.isSliding);
            });
            return null;
        }
    }
}

