/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.network;

import com.alrex.parcool.ParCool;
import com.alrex.parcool.common.capability.IFastRunning;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SyncFastRunningMessage
implements IMessage {
    private boolean isFastRunning = false;
    private UUID playerID = null;

    public void toBytes(ByteBuf packet) {
        packet.writeBoolean(this.isFastRunning);
        packet.writeLong(this.playerID.getMostSignificantBits());
        packet.writeLong(this.playerID.getLeastSignificantBits());
    }

    public void fromBytes(ByteBuf packet) {
        this.isFastRunning = packet.readBoolean();
        this.playerID = new UUID(packet.readLong(), packet.readLong());
    }

    @SideOnly(value=Side.CLIENT)
    public static void sync(EntityPlayer player) {
        IFastRunning fastRunning = IFastRunning.get(player);
        SyncFastRunningMessage message = new SyncFastRunningMessage();
        message.isFastRunning = fastRunning.isFastRunning();
        message.playerID = player.func_110124_au();
        ParCool.CHANNEL_INSTANCE.sendToServer((IMessage)message);
    }

    @SideOnly(value=Side.CLIENT)
    public static class ClientHandler
    implements IMessageHandler<SyncFastRunningMessage, SyncFastRunningMessage> {
        public SyncFastRunningMessage onMessage(SyncFastRunningMessage message, MessageContext context) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                IFastRunning fastRunning;
                EntityPlayerMP player;
                if (context.side == Side.CLIENT) {
                    WorldClient world = Minecraft.func_71410_x().field_71441_e;
                    if (world == null) {
                        return;
                    }
                    player = world.func_152378_a(message.playerID);
                    if (player == null || player.func_175144_cb()) {
                        return;
                    }
                } else {
                    player = context.getServerHandler().field_147369_b;
                    ParCool.CHANNEL_INSTANCE.sendToAll((IMessage)message);
                    if (player == null) {
                        return;
                    }
                }
                if ((fastRunning = IFastRunning.get((EntityPlayer)player)) == null) {
                    return;
                }
                fastRunning.setFastRunning(message.isFastRunning);
            });
            return null;
        }
    }

    @SideOnly(value=Side.SERVER)
    public static class ServerHandler
    implements IMessageHandler<SyncFastRunningMessage, SyncFastRunningMessage> {
        public SyncFastRunningMessage onMessage(SyncFastRunningMessage message, MessageContext context) {
            EntityPlayerMP player = context.getServerHandler().field_147369_b;
            player.func_71121_q().func_152344_a(() -> {
                ParCool.CHANNEL_INSTANCE.sendToAll((IMessage)message);
                IFastRunning fastRunning = IFastRunning.get((EntityPlayer)player);
                if (fastRunning == null) {
                    return;
                }
                fastRunning.setFastRunning(message.isFastRunning);
            });
            return null;
        }
    }
}

