/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.processor;

import com.alrex.parcool.ParCool;
import com.alrex.parcool.common.capability.ICrawl;
import com.alrex.parcool.common.network.SyncCrawlMessage;
import com.alrex.parcool.utilities.PlayerUtils;
import com.alrex.parcool.utilities.VectorUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CrawlLogic {
    private static Vec3d slidingVec = null;
    private static boolean isCrawlEyeHeight = false;

    @SubscribeEvent
    public static void onTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        ICrawl crawl = ICrawl.get(player);
        if (crawl == null) {
            return;
        }
        if (crawl.isCrawling() || crawl.isSliding()) {
            player.func_70031_b(false);
            PlayerUtils.setCrawlSize(player);
            Vec3d vec = PlayerUtils.getVelocity((Entity)player);
            PlayerUtils.setVelocity((Entity)player, new Vec3d(vec.field_72450_a / 2.0, vec.field_72448_b, vec.field_72449_c / 2.0));
            player.eyeHeight = player.getDefaultEyeHeight() / 2.0f;
            isCrawlEyeHeight = true;
        } else if (isCrawlEyeHeight) {
            isCrawlEyeHeight = false;
            player.eyeHeight = player.getDefaultEyeHeight();
        }
        if (!ParCool.isActive()) {
            return;
        }
        if (!player.func_175144_cb() || event.phase != TickEvent.Phase.START || event.side == Side.SERVER) {
            return;
        }
        boolean oldCrawling = crawl.isCrawling();
        crawl.setCrawling(crawl.canCrawl(player));
        boolean oldSliding = crawl.isSliding();
        crawl.setSliding(crawl.canSliding(player));
        crawl.updateSlidingTime(player);
        if (crawl.isCrawling() != oldCrawling || crawl.isSliding() != oldSliding) {
            SyncCrawlMessage.sync(player);
        }
        if (!oldSliding && crawl.isSliding()) {
            Vec3d vec = PlayerUtils.getVelocity((Entity)player);
            slidingVec = new Vec3d(vec.field_72450_a, 0.0, vec.field_72449_c).func_186678_a(3.0);
        }
        if (crawl.isSliding()) {
            if (player.field_70124_G) {
                PlayerUtils.setVelocity((Entity)player, slidingVec);
            }
            slidingVec = slidingVec.func_186678_a(0.9);
        }
        if (crawl.isSliding()) {
            player.field_70177_z = (float)(Math.atan2(CrawlLogic.slidingVec.field_72449_c, CrawlLogic.slidingVec.field_72450_a) * 180.0 / Math.PI - 90.0);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onRender(TickEvent.RenderTickEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null || !ParCool.isActive()) {
            return;
        }
        ICrawl crawl = ICrawl.get((EntityPlayer)player);
        if (crawl == null) {
            return;
        }
        if (crawl.isSliding()) {
            player.field_70177_z = (float)VectorUtil.toYawDegree(slidingVec);
        }
    }
}

