/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.processor;

import com.alrex.parcool.ParCool;
import com.alrex.parcool.common.capability.IGrabCliff;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.network.ResetFallDistanceMessage;
import com.alrex.parcool.common.network.SyncGrabCliffMessage;
import com.alrex.parcool.utilities.PlayerUtils;
import com.alrex.parcool.utilities.VectorUtil;
import com.alrex.parcool.utilities.WorldUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GrabCliffLogic {
    @SubscribeEvent
    public static void onTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (event.side == Side.SERVER) {
            return;
        }
        EntityPlayer player = event.player;
        IStamina stamina = IStamina.get(player);
        IGrabCliff grabCliff = IGrabCliff.get(player);
        if (stamina == null || grabCliff == null) {
            return;
        }
        grabCliff.updateTime();
        if (!player.func_175144_cb()) {
            return;
        }
        if (!ParCool.isActive()) {
            return;
        }
        boolean oldGrabbing = grabCliff.isGrabbing();
        grabCliff.setGrabbing(grabCliff.canGrabCliff(player));
        if (oldGrabbing != grabCliff.isGrabbing()) {
            SyncGrabCliffMessage.sync(player);
            ResetFallDistanceMessage.sync(player);
        }
        if (grabCliff.isGrabbing()) {
            Vec3d vec = PlayerUtils.getVelocity((Entity)player);
            PlayerUtils.setVelocity((Entity)player, new Vec3d(vec.field_72450_a / 10.0, vec.field_72448_b > 0.1 ? vec.field_72448_b / 10.0 : 0.0, vec.field_72449_c / 10.0));
            stamina.consume(grabCliff.getStaminaConsumptionGrab());
        }
        if (grabCliff.canJumpOnCliff(player)) {
            player.func_70024_g(0.0, 0.6, 0.0);
            stamina.consume(grabCliff.getStaminaConsumptionClimbUp());
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onRender(TickEvent.RenderTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        if (!ParCool.isActive()) {
            return;
        }
        IGrabCliff grabCliff = IGrabCliff.get((EntityPlayer)player);
        if (grabCliff == null) {
            return;
        }
        if (grabCliff.isGrabbing()) {
            Vec3d wall = WorldUtil.getWall((EntityLivingBase)player);
            Vec3d look = player.func_70040_Z();
            if (wall != null) {
                player.field_70177_z = (float)VectorUtil.toYawDegree(wall.func_72432_b().func_178787_e(look.func_72432_b()));
            }
        }
    }
}

