/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.processor;

import com.alrex.parcool.ParCool;
import com.alrex.parcool.common.capability.ICatLeap;
import com.alrex.parcool.common.capability.ICrawl;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.network.SyncCatLeapMessage;
import com.alrex.parcool.utilities.PlayerUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class JumpBoostLogic {
    @SubscribeEvent
    public static void onTick(TickEvent.PlayerTickEvent event) {
        if (event.side == Side.SERVER || event.phase != TickEvent.Phase.START) {
            return;
        }
        EntityPlayer player = event.player;
        ICatLeap catLeap = ICatLeap.get(player);
        IStamina stamina = IStamina.get(player);
        if (catLeap == null || stamina == null) {
            return;
        }
        if (!player.func_175144_cb()) {
            return;
        }
        catLeap.updateReadyTime();
        boolean oldLeaping = catLeap.isLeaping();
        if (catLeap.canCatLeap(player)) {
            Vec3d motionVec = PlayerUtils.getVelocity((Entity)player);
            Vec3d vec = new Vec3d(motionVec.field_72450_a, 0.0, motionVec.field_72449_c).func_72432_b();
            PlayerUtils.setVelocity((Entity)player, new Vec3d(vec.field_72450_a, catLeap.getBoostValue(player), vec.field_72449_c));
            stamina.consume(catLeap.getStaminaConsumption());
            catLeap.setLeaping(true);
            catLeap.setReady(false);
        } else if (catLeap.isLeaping() && (player.field_70123_F || player.field_70124_G || player.func_70090_H())) {
            catLeap.setLeaping(false);
        }
        catLeap.setReady(catLeap.canReadyLeap(player));
        if (oldLeaping != catLeap.isLeaping()) {
            SyncCatLeapMessage.sync(player);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onLivingJump(LivingEvent.LivingJumpEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer EntityPlayer2 = (EntityPlayer)entity;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != entity) {
            return;
        }
        if (!ParCool.isActive()) {
            return;
        }
        ICrawl crawl = ICrawl.get((EntityPlayer)player);
        IStamina stamina = IStamina.get((EntityPlayer)player);
        if (crawl == null || stamina == null) {
            return;
        }
        if (stamina.isExhausted()) {
            Vec3d vec = PlayerUtils.getVelocity((Entity)player);
            PlayerUtils.setVelocity((Entity)player, new Vec3d(vec.field_72450_a, 0.3, vec.field_72449_c));
            return;
        }
        if (crawl.isSliding()) {
            Vec3d vec = PlayerUtils.getVelocity((Entity)player);
            PlayerUtils.setVelocity((Entity)player, new Vec3d(vec.field_72450_a, 0.0, vec.field_72449_c));
        }
    }
}

