/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.processor;

import com.alrex.parcool.common.capability.IRoll;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.network.StartRollMessage;
import com.alrex.parcool.common.network.SyncRollReadyMessage;
import com.alrex.parcool.utilities.PlayerUtils;
import com.alrex.parcool.utilities.VectorUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RollLogic {
    private static Vec3d rollDirection = null;

    @SideOnly(value=Side.CLIENT)
    public static void rollStart() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        IRoll roll = IRoll.get((EntityPlayer)player);
        if (roll == null) {
            return;
        }
        roll.setRollReady(false);
        roll.setRolling(true);
        Vec3d lookVec = player.func_70040_Z();
        Vec3d motionVec = PlayerUtils.getVelocity((Entity)player);
        lookVec = new Vec3d(lookVec.field_72450_a, 0.0, lookVec.field_72449_c).func_72432_b();
        motionVec = new Vec3d(motionVec.field_72450_a, 0.0, motionVec.field_72449_c);
        double speed = motionVec.func_72433_c();
        if (speed < 0.8) {
            speed = 0.8;
        }
        rollDirection = lookVec.func_178787_e(motionVec.func_72432_b()).func_72432_b().func_186678_a(speed / 1.4);
    }

    @SubscribeEvent
    public static void onTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (event.side != Side.CLIENT) {
            return;
        }
        EntityPlayer player = event.player;
        IStamina stamina = IStamina.get(player);
        IRoll roll = IRoll.get(player);
        if (stamina == null || roll == null) {
            return;
        }
        roll.updateRollingTime();
        if (!player.func_175144_cb()) {
            return;
        }
        boolean oldReady = roll.isRollReady();
        if (roll.isRollReady()) {
            roll.setRollReady(roll.canContinueRollReady(player));
            stamina.consume(roll.getStaminaConsumption());
        } else {
            roll.setRollReady(roll.canRollReady(player));
        }
        if (roll.isRollReady() != oldReady) {
            SyncRollReadyMessage.sync(player);
        }
        if (roll.isRolling()) {
            if (rollDirection == null) {
                return;
            }
            rollDirection.func_186678_a(0.7);
            Vec3d motion = PlayerUtils.getVelocity((Entity)player);
            PlayerUtils.setVelocity((Entity)player, new Vec3d(RollLogic.rollDirection.field_72450_a, motion.field_72448_b, RollLogic.rollDirection.field_72449_c));
        }
        if (roll.getRollingTime() >= roll.getRollAnimateTime()) {
            roll.setRolling(false);
            rollDirection = null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onRender(RenderPlayerEvent.Pre event) {
        if (event.getEntityPlayer() != Minecraft.func_71410_x().field_71439_g) {
            return;
        }
        if (rollDirection != null) {
            event.getEntityPlayer().field_70177_z = (float)VectorUtil.toYawDegree(rollDirection);
        }
    }

    @SubscribeEvent
    public static void onDamage(LivingDamageEvent event) {
        if (!(event.getEntityLiving() instanceof EntityPlayerMP) || !event.getSource().func_76355_l().equals(DamageSource.field_76379_h.func_76355_l())) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.getEntityLiving();
        IRoll roll = IRoll.get((EntityPlayer)player);
        if (roll == null) {
            return;
        }
        if (roll.isRollReady()) {
            roll.setRollReady(false);
            StartRollMessage.send(player);
            float damage = event.getAmount();
            if (damage < 2.0f) {
                event.setCanceled(true);
            } else {
                event.setAmount((damage - 2.0f) / 2.0f);
            }
        }
    }
}

