/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.utilities;

import com.alrex.parcool.utilities.PlayerUtils;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class WorldUtil {
    @Nullable
    public static Vec3d getWall(EntityLivingBase entity) {
        double d = 0.3;
        double distance = PlayerUtils.getWidth((Entity)entity) / 2.0f;
        double wallX = 0.0;
        double wallZ = 0.0;
        int wallNumX = 0;
        int wallNumZ = 0;
        AxisAlignedBB baseBox = new AxisAlignedBB(entity.field_70165_t - 0.3, entity.field_70163_u, entity.field_70161_v - 0.3, entity.field_70165_t + 0.3, entity.field_70163_u + (double)PlayerUtils.getHeight((Entity)entity), entity.field_70161_v + 0.3);
        if (entity.field_70170_p.func_72829_c(baseBox.func_72321_a(distance, 0.0, 0.0))) {
            wallX += 1.0;
            wallNumX = (byte)(wallNumX + 1);
        }
        if (entity.field_70170_p.func_72829_c(baseBox.func_72321_a(-distance, 0.0, 0.0))) {
            wallX -= 1.0;
            wallNumX = (byte)(wallNumX + 1);
        }
        if (entity.field_70170_p.func_72829_c(baseBox.func_72321_a(0.0, 0.0, distance))) {
            wallZ += 1.0;
            wallNumZ = (byte)(wallNumZ + 1);
        }
        if (entity.field_70170_p.func_72829_c(baseBox.func_72321_a(0.0, 0.0, -distance))) {
            wallZ -= 1.0;
            wallNumZ = (byte)(wallNumZ + 1);
        }
        if (wallNumX == 2 || wallNumZ == 2 || wallNumX == 0 && wallNumZ == 0) {
            return null;
        }
        return new Vec3d(wallX, 0.0, wallZ);
    }

    @Nullable
    public static Vec3d getStep(EntityLivingBase entity) {
        double d = 0.3;
        World world = entity.field_70170_p;
        double distance = PlayerUtils.getWidth((Entity)entity) / 2.0f;
        double baseLine = 1.55;
        double stepX = 0.0;
        double stepZ = 0.0;
        AxisAlignedBB baseBoxSide = new AxisAlignedBB(entity.field_70165_t - 0.3, entity.field_70163_u, entity.field_70161_v - 0.3, entity.field_70165_t + 0.3, entity.field_70163_u + baseLine, entity.field_70161_v + 0.3);
        AxisAlignedBB baseBoxTop = new AxisAlignedBB(entity.field_70165_t - 0.3, entity.field_70163_u + baseLine, entity.field_70161_v - 0.3, entity.field_70165_t + 0.3, entity.field_70163_u + (double)PlayerUtils.getHeight((Entity)entity), entity.field_70161_v + 0.3);
        if (world.func_72829_c(baseBoxSide.func_72321_a(distance, 0.0, 0.0)) && !world.func_72829_c(baseBoxTop.func_72321_a(distance, 0.0, 0.0))) {
            stepX += 1.0;
        }
        if (world.func_72829_c(baseBoxSide.func_72321_a(-distance, 0.0, 0.0)) && !world.func_72829_c(baseBoxTop.func_72321_a(-distance, 0.0, 0.0))) {
            stepX -= 1.0;
        }
        if (world.func_72829_c(baseBoxSide.func_72321_a(0.0, 0.0, distance)) && !world.func_72829_c(baseBoxTop.func_72321_a(0.0, 0.0, distance))) {
            stepZ += 1.0;
        }
        if (world.func_72829_c(baseBoxSide.func_72321_a(0.0, 0.0, -distance)) && !world.func_72829_c(baseBoxTop.func_72321_a(0.0, 0.0, -distance))) {
            stepZ -= 1.0;
        }
        if (stepX == 0.0 && stepZ == 0.0) {
            return null;
        }
        return new Vec3d(stepX, 0.0, stepZ);
    }

    public static double getWallHeight(EntityLivingBase entity) {
        Vec3d wall = WorldUtil.getWall(entity);
        if (wall == null) {
            return 0.0;
        }
        World world = entity.field_70170_p;
        double v = 0.1;
        double d = 0.3;
        int loopNum = (int)Math.round((double)PlayerUtils.getHeight((Entity)entity) / 0.1);
        double x1 = entity.field_70165_t + 0.3 + (double)(wall.field_72450_a > 0.0 ? 1 : 0);
        double y1 = entity.field_70163_u;
        double z1 = entity.field_70161_v + 0.3 + (double)(wall.field_72449_c > 0.0 ? 1 : 0);
        double x2 = entity.field_70165_t - 0.3 + (double)(wall.field_72450_a < 0.0 ? -1 : 0);
        double z2 = entity.field_70161_v - 0.3 + (double)(wall.field_72449_c < 0.0 ? -1 : 0);
        boolean canReturn = false;
        for (int i = 0; i < loopNum; ++i) {
            AxisAlignedBB box = new AxisAlignedBB(x1, y1 + 0.1 * (double)i, z1, x2, y1 + 0.1 * (double)(i + 1), z2);
            if (!world.func_72829_c(box)) {
                canReturn = true;
                continue;
            }
            if (!canReturn) continue;
            return 0.1 * (double)i;
        }
        return PlayerUtils.getHeight((Entity)entity);
    }

    public static boolean existsGrabbableWall(EntityLivingBase entity) {
        double d = 0.3;
        World world = entity.func_130014_f_();
        double distance = PlayerUtils.getWidth((Entity)entity) / 2.0f;
        double baseLine = entity.func_70047_e() + (PlayerUtils.getHeight((Entity)entity) - entity.func_70047_e()) / 2.0f;
        AxisAlignedBB baseBoxSide = new AxisAlignedBB(entity.field_70165_t - 0.3, entity.field_70163_u + baseLine - (double)(PlayerUtils.getHeight((Entity)entity) / 6.0f), entity.field_70161_v - 0.3, entity.field_70165_t + 0.3, entity.field_70163_u + baseLine, entity.field_70161_v + 0.3);
        AxisAlignedBB baseBoxTop = new AxisAlignedBB(entity.field_70165_t - 0.3, entity.field_70163_u + baseLine, entity.field_70161_v - 0.3, entity.field_70165_t + 0.3, entity.field_70163_u + (double)PlayerUtils.getHeight((Entity)entity), entity.field_70161_v + 0.3);
        if (world.func_72829_c(baseBoxSide.func_72321_a(distance, 0.0, 0.0)) && !world.func_72829_c(baseBoxTop.func_72321_a(distance, 0.0, 0.0))) {
            return true;
        }
        if (world.func_72829_c(baseBoxSide.func_72321_a(-distance, 0.0, 0.0)) && !world.func_72829_c(baseBoxTop.func_72321_a(-distance, 0.0, 0.0))) {
            return true;
        }
        if (world.func_72829_c(baseBoxSide.func_72321_a(0.0, 0.0, distance)) && !world.func_72829_c(baseBoxTop.func_72321_a(0.0, 0.0, distance))) {
            return true;
        }
        return world.func_72829_c(baseBoxSide.func_72321_a(0.0, 0.0, -distance)) && !world.func_72829_c(baseBoxTop.func_72321_a(0.0, 0.0, -distance));
    }
}

