/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.api;

import com.alrex.parcool.common.capability.IStamina;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Stamina {
    private final IStamina staminaInstance;

    @Nullable
    public static Stamina get(PlayerEntity player) {
        IStamina instance = IStamina.get(player);
        if (instance == null) {
            return null;
        }
        return new Stamina(instance);
    }

    private Stamina(IStamina staminaInstance) {
        this.staminaInstance = staminaInstance;
    }

    public int getMaxValue() {
        return this.staminaInstance.getActualMaxStamina();
    }

    public int getValue() {
        return this.staminaInstance.get();
    }

    public boolean isExhausted() {
        return this.staminaInstance.isExhausted();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setValue(int value) {
        if (value < 0) {
            value = 0;
        } else if (value > this.getMaxValue()) {
            value = this.getMaxValue();
        }
        this.staminaInstance.set(value);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void consume(int value) {
        this.staminaInstance.consume(value);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void recover(int value) {
        this.staminaInstance.recover(value);
    }
}

