/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.client.animation;

import com.alrex.parcool.client.animation.PlayerModelRotator;
import com.alrex.parcool.client.animation.PlayerModelTransformer;
import com.alrex.parcool.client.input.KeyBindings;
import com.alrex.parcool.common.action.impl.ClingToCliff;
import com.alrex.parcool.common.action.impl.Dive;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.config.ParCoolConfig;
import com.alrex.parcool.utilities.EasingFunctions;
import com.alrex.parcool.utilities.MathUtil;
import com.alrex.parcool.utilities.VectorUtil;
import java.util.Random;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class PassiveCustomAnimation {
    private int fallingAnimationTick = 0;
    private static final int FallingStartLine = 14;
    private int flyingAnimationLevelOld = 0;
    private int flyingAnimationLevel = 0;
    private static final int flyingMaxLevel = 20;

    public void tick(PlayerEntity player, Parkourability parkourability) {
        this.flyingAnimationLevelOld = this.flyingAnimationLevel++;
        if (KeyBindings.getKeyForward().func_151470_d() && player.field_71075_bZ.field_75100_b) {
            if (this.flyingAnimationLevel > 20) {
                this.flyingAnimationLevel = 20;
            }
        } else {
            --this.flyingAnimationLevel;
            if (this.flyingAnimationLevel < 0) {
                this.flyingAnimationLevel = 0;
            }
        }
        this.fallingAnimationTick = !(player.func_233570_aj_() || !(player.field_70143_R > 1.0f) || player.field_71075_bZ.field_75100_b || player.func_184613_cA() || parkourability.get(ClingToCliff.class).isDoing()) ? ++this.fallingAnimationTick : 0;
    }

    public void animate(PlayerEntity player, Parkourability parkourability, PlayerModelTransformer transformer) {
        if (this.fallingAnimationTick >= 14 && ParCoolConfig.Client.Booleans.EnableFallingAnimation.get().booleanValue() && !parkourability.get(Dive.class).isDoing()) {
            this.animateFalling(parkourability, transformer);
        }
    }

    public void rotate(PlayerEntity player, Parkourability parkourability, PlayerModelRotator rotator) {
    }

    private void animateFalling(Parkourability parkourability, PlayerModelTransformer transformer) {
        float phase = ((float)this.fallingAnimationTick + transformer.getPartialTick() - 14.0f) / 14.0f;
        float factor = phase > 1.0f ? 1.0f : EasingFunctions.SinInOutBySquare(phase);
        transformer.addRotateRightArm(0.0f, 0.0f, (float)Math.toRadians(80.0f * factor)).addRotateLeftArm(0.0f, 0.0f, (float)Math.toRadians(-80.0f * factor)).addRotateRightLeg(0.0f, 0.0f, (float)Math.toRadians(10.0f * factor)).addRotateLeftLeg(0.0f, 0.0f, (float)Math.toRadians(-10.0f * factor)).makeArmsMoveDynamically(factor).makeLegsShakingDynamically(factor).end();
    }

    private void animateCreativeFlying(PlayerEntity player, PlayerModelTransformer transformer) {
        float angle = this.getAngleCreativeFlying(player, transformer.getPartialTick());
        float factor = this.getFactorCreativeFlying(transformer.getPartialTick());
        if (this.flyingAnimationLevel > 0) {
            transformer.rotateAdditionallyHeadPitch(-angle).rotateRightArm((float)Math.toRadians(-170.0f * factor), (float)Math.toRadians(90.0f * factor), 0.0f).rotateLeftArm((float)Math.toRadians(-170.0f * factor), (float)Math.toRadians(-90.0f * factor), 0.0f).makeArmsNatural().rotateLeftLeg(0.0f, 0.0f, 0.0f).rotateRightLeg(0.0f, 0.0f, 0.0f).makeLegsLittleMoving().end();
        }
    }

    private void rotateCreativeFlying(PlayerEntity player, PlayerModelRotator rotator) {
        rotator.startBasedCenter().rotatePitchFrontward(this.getAngleCreativeFlying(player, rotator.getPartialTick())).end();
    }

    private void spawnSweatParticle(PlayerEntity player) {
        World level = player.field_70170_p;
        Random rand = player.func_70681_au();
        Vector3d particleSpeed = player.func_213322_ci().func_186678_a(0.6);
        level.func_195594_a((IParticleData)ParticleTypes.field_197618_k, player.func_226277_ct_() + (double)(player.func_213311_cf() * (rand.nextFloat() - 0.5f)), player.func_226278_cu_() + (double)(player.func_213302_cg() * rand.nextFloat()), player.func_226281_cx_() + (double)(player.func_213311_cf() * (rand.nextFloat() - 0.5f)), particleSpeed.func_82615_a(), particleSpeed.func_82617_b() - 1.0, particleSpeed.func_82616_c());
    }

    private float getAngleCreativeFlying(PlayerEntity player, float partial) {
        float xRot = (float)VectorUtil.toPitchDegree(player.func_213322_ci());
        return (xRot + 90.0f) * this.getFactorCreativeFlying(partial);
    }

    private float getFactorCreativeFlying(float partial) {
        return EasingFunctions.SinInOutBySquare(MathUtil.lerp(this.flyingAnimationLevelOld, this.flyingAnimationLevel, partial) / 20.0f);
    }
}

