/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.client.animation;

import com.alrex.parcool.api.unstable.animation.AnimationOption;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.vector.Vector3f;

public class PlayerModelRotator {
    private final MatrixStack stack;
    private final PlayerEntity player;
    private final float partial;
    private AnimationOption option = new AnimationOption();
    private double playerHeight = 1.8;
    private final float givenXRot;
    private final float givenYRot;
    private final float givenZRot;
    private boolean basedCenter = false;
    private boolean basedTop = false;

    public float getXRot() {
        return this.givenXRot;
    }

    public float getYRot() {
        return this.givenYRot;
    }

    public float getZRot() {
        return this.givenZRot;
    }

    public float getPartialTick() {
        return this.partial;
    }

    public PlayerModelRotator(MatrixStack stack, PlayerEntity player, float partial, float xRot, float yRot, float zRot) {
        this.stack = stack;
        this.player = player;
        this.partial = partial;
        this.givenXRot = xRot;
        this.givenYRot = yRot;
        this.givenZRot = zRot;
        switch (player.func_213283_Z()) {
            case SWIMMING: 
            case CROUCHING: 
            case SLEEPING: {
                this.playerHeight = 0.6;
            }
        }
    }

    public void setOption(AnimationOption option) {
        this.option = option;
    }

    public PlayerModelRotator start() {
        return this;
    }

    public PlayerModelRotator startBasedCenter() {
        this.basedCenter = true;
        this.stack.func_227861_a_(0.0, this.playerHeight / 2.0, 0.0);
        return this;
    }

    public PlayerModelRotator startBasedTop() {
        this.basedTop = true;
        this.stack.func_227861_a_(0.0, this.playerHeight, 0.0);
        return this;
    }

    public MatrixStack getRawStack() {
        return this.stack;
    }

    public PlayerModelRotator translateY(float offset) {
        this.stack.func_227861_a_(0.0, (double)offset, 0.0);
        return this;
    }

    public PlayerModelRotator translate(float offsetX, float offsetY, float offsetZ) {
        this.stack.func_227861_a_((double)offsetX, (double)offsetY, (double)offsetZ);
        return this;
    }

    public PlayerModelRotator rotatePitchFrontward(float angleDegree) {
        this.stack.func_227863_a_(Vector3f.field_229178_a_.func_229187_a_(angleDegree));
        return this;
    }

    public PlayerModelRotator rotateRollRightward(float angleDegree) {
        this.stack.func_227863_a_(Vector3f.field_229182_e_.func_229187_a_(angleDegree));
        return this;
    }

    public PlayerModelRotator rotateYawRightward(float angleDegree) {
        this.stack.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_(angleDegree));
        return this;
    }

    public void end() {
        if (this.basedCenter) {
            this.stack.func_227861_a_(0.0, -this.playerHeight / 2.0, 0.0);
        }
        if (this.basedTop) {
            this.stack.func_227861_a_(0.0, -this.playerHeight, 0.0);
        }
    }

    public void endEnabledLegGrounding() {
        this.end();
    }
}

