/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.client.animation;

import com.alrex.parcool.api.unstable.animation.AnimationOption;
import com.alrex.parcool.api.unstable.animation.AnimationPart;
import com.alrex.parcool.utilities.MathUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.ModelHelper;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.MathHelper;

public class PlayerModelTransformer {
    private final PlayerEntity player;
    private final PlayerModel model;
    private final float partial;
    private final float ageInTicks;
    private final float limbSwing;
    private final float limbSwingAmount;
    private final float netHeadYaw;
    private final float headPitch;
    private AnimationOption option = new AnimationOption();

    public float getPartialTick() {
        return this.partial;
    }

    public float getHeadPitch() {
        return this.headPitch;
    }

    public float getNetHeadYaw() {
        return this.netHeadYaw;
    }

    public float getLimbSwing() {
        return this.limbSwing;
    }

    public float getLimbSwingAmount() {
        return this.limbSwingAmount;
    }

    public PlayerModel getRawModel() {
        return this.model;
    }

    public PlayerModelTransformer(PlayerEntity player, PlayerModel model, boolean slim, float ageInTicks, float limbSwing, float limbSwingAmount, float netHeadYaw, float headPitch) {
        this.player = player;
        this.model = model;
        this.partial = Minecraft.func_71410_x().func_184121_ak();
        this.ageInTicks = ageInTicks;
        this.limbSwing = limbSwing;
        this.limbSwingAmount = limbSwingAmount;
        this.netHeadYaw = netHeadYaw;
        this.headPitch = headPitch;
    }

    public void setOption(AnimationOption option) {
        this.option = option;
    }

    public PlayerModelTransformer rotateRightArm(float angleX, float angleY, float angleZ) {
        if (this.option.isCanceled(AnimationPart.RIGHT_ARM)) {
            return this;
        }
        ModelRenderer rightArm = this.model.field_178723_h;
        if (rightArm.field_78806_j) {
            this.setRotations(rightArm, angleX, angleY, angleZ);
        }
        return this;
    }

    public PlayerModelTransformer rotateRightArm(float angleX, float angleY, float angleZ, float factor) {
        if (this.option.isCanceled(AnimationPart.RIGHT_ARM)) {
            return this;
        }
        ModelRenderer rightArm = this.model.field_178723_h;
        if (rightArm.field_78806_j) {
            this.setRotations(rightArm, MathUtil.lerp(rightArm.field_78795_f, angleX, factor), MathUtil.lerp(rightArm.field_78796_g, angleY, factor), MathUtil.lerp(rightArm.field_78808_h, angleZ, factor));
        }
        return this;
    }

    public PlayerModelTransformer rotateLeftArm(float angleX, float angleY, float angleZ) {
        if (this.option.isCanceled(AnimationPart.LEFT_ARM)) {
            return this;
        }
        ModelRenderer leftArm = this.model.field_178724_i;
        if (leftArm.field_78806_j) {
            this.setRotations(leftArm, angleX, angleY, angleZ);
        }
        return this;
    }

    public PlayerModelTransformer rotateLeftArm(float angleX, float angleY, float angleZ, float factor) {
        if (this.option.isCanceled(AnimationPart.LEFT_ARM)) {
            return this;
        }
        ModelRenderer leftArm = this.model.field_178724_i;
        if (leftArm.field_78806_j) {
            this.setRotations(leftArm, MathUtil.lerp(leftArm.field_78795_f, angleX, factor), MathUtil.lerp(leftArm.field_78796_g, angleY, factor), MathUtil.lerp(leftArm.field_78808_h, angleZ, factor));
        }
        return this;
    }

    public PlayerModelTransformer rotateRightLeg(float angleX, float angleY, float angleZ) {
        if (this.option.isCanceled(AnimationPart.RIGHT_LEG)) {
            return this;
        }
        ModelRenderer rightLeg = this.model.field_178721_j;
        if (rightLeg.field_78806_j) {
            this.setRotations(rightLeg, angleX, angleY, angleZ);
        }
        return this;
    }

    public PlayerModelTransformer rotateRightLeg(float angleX, float angleY, float angleZ, float factor) {
        if (this.option.isCanceled(AnimationPart.RIGHT_LEG)) {
            return this;
        }
        ModelRenderer rightLeg = this.model.field_178721_j;
        if (rightLeg.field_78806_j) {
            this.setRotations(rightLeg, MathUtil.lerp(rightLeg.field_78795_f, angleX, factor), MathUtil.lerp(rightLeg.field_78796_g, angleY, factor), MathUtil.lerp(rightLeg.field_78808_h, angleZ, factor));
        }
        return this;
    }

    public PlayerModelTransformer rotateLeftLeg(float angleX, float angleY, float angleZ) {
        if (this.option.isCanceled(AnimationPart.LEFT_LEG)) {
            return this;
        }
        ModelRenderer leftLeg = this.model.field_178722_k;
        if (leftLeg.field_78806_j) {
            this.setRotations(leftLeg, angleX, angleY, angleZ);
        }
        return this;
    }

    public PlayerModelTransformer rotateLeftLeg(float angleX, float angleY, float angleZ, float factor) {
        if (this.option.isCanceled(AnimationPart.LEFT_LEG)) {
            return this;
        }
        ModelRenderer leftLeg = this.model.field_178722_k;
        if (leftLeg.field_78806_j) {
            this.setRotations(leftLeg, MathUtil.lerp(leftLeg.field_78795_f, angleX, factor), MathUtil.lerp(leftLeg.field_78796_g, angleY, factor), MathUtil.lerp(leftLeg.field_78808_h, angleZ, factor));
        }
        return this;
    }

    public PlayerModelTransformer addRotateRightArm(float angleX, float angleY, float angleZ) {
        if (this.option.isCanceled(AnimationPart.RIGHT_ARM)) {
            return this;
        }
        ModelRenderer arm = this.model.field_178723_h;
        if (arm.field_78806_j) {
            this.setRotations(arm, arm.field_78795_f + angleX, arm.field_78796_g + angleY, arm.field_78808_h + angleZ);
        }
        return this;
    }

    public PlayerModelTransformer addRotateLeftArm(float angleX, float angleY, float angleZ) {
        if (this.option.isCanceled(AnimationPart.LEFT_ARM)) {
            return this;
        }
        ModelRenderer arm = this.model.field_178724_i;
        if (arm.field_78806_j) {
            this.setRotations(arm, arm.field_78795_f + angleX, arm.field_78796_g + angleY, arm.field_78808_h + angleZ);
        }
        return this;
    }

    public PlayerModelTransformer addRotateRightLeg(float angleX, float angleY, float angleZ) {
        if (this.option.isCanceled(AnimationPart.RIGHT_LEG)) {
            return this;
        }
        ModelRenderer leg = this.model.field_178721_j;
        if (leg.field_78806_j) {
            this.setRotations(leg, leg.field_78795_f + angleX, leg.field_78796_g + angleY, leg.field_78808_h + angleZ);
        }
        return this;
    }

    public PlayerModelTransformer addRotateLeftLeg(float angleX, float angleY, float angleZ) {
        if (this.option.isCanceled(AnimationPart.LEFT_LEG)) {
            return this;
        }
        ModelRenderer leg = this.model.field_178722_k;
        if (leg.field_78806_j) {
            this.setRotations(leg, leg.field_78795_f + angleX, leg.field_78796_g + angleY, leg.field_78808_h + angleZ);
        }
        return this;
    }

    public PlayerModelTransformer addRotateRightArm(float angleX, float angleY, float angleZ, float factor) {
        if (this.option.isCanceled(AnimationPart.RIGHT_ARM)) {
            return this;
        }
        return this.addRotateRightArm(angleX * factor, angleY * factor, angleZ * factor);
    }

    public PlayerModelTransformer addRotateLeftArm(float angleX, float angleY, float angleZ, float factor) {
        if (this.option.isCanceled(AnimationPart.LEFT_ARM)) {
            return this;
        }
        return this.addRotateLeftArm(angleX * factor, angleY * factor, angleZ * factor);
    }

    public PlayerModelTransformer addRotateRightLeg(float angleX, float angleY, float angleZ, float factor) {
        if (this.option.isCanceled(AnimationPart.RIGHT_LEG)) {
            return this;
        }
        return this.addRotateRightLeg(angleX * factor, angleY * factor, angleZ * factor);
    }

    public PlayerModelTransformer addRotateLeftLeg(float angleX, float angleY, float angleZ, float factor) {
        if (this.option.isCanceled(AnimationPart.LEFT_LEG)) {
            return this;
        }
        return this.addRotateLeftLeg(angleX * factor, angleY * factor, angleZ * factor);
    }

    public PlayerModelTransformer makeArmsNatural() {
        if (this.option.isCanceled(AnimationPart.RIGHT_ARM)) {
            return this;
        }
        if (this.option.isCanceled(AnimationPart.LEFT_ARM)) {
            return this;
        }
        ModelHelper.func_239101_a_((ModelRenderer)this.model.field_178723_h, (ModelRenderer)this.model.field_178724_i, (float)this.ageInTicks);
        return this;
    }

    public PlayerModelTransformer makeLegsMoveDynamically(float factor) {
        if (this.option.isCanceled(AnimationPart.RIGHT_LEG)) {
            return this;
        }
        if (this.option.isCanceled(AnimationPart.LEFT_LEG)) {
            return this;
        }
        this.model.field_178721_j.field_78808_h += MathHelper.func_76134_b((float)(this.ageInTicks * 0.56f)) * 0.8f * factor + 0.05f;
        this.model.field_178722_k.field_78808_h -= MathHelper.func_76134_b((float)(this.ageInTicks * 0.56f)) * 0.8f * factor + 0.05f;
        this.model.field_178721_j.field_78795_f += MathHelper.func_76126_a((float)(this.ageInTicks * 0.56f)) * 0.8f * factor;
        this.model.field_178722_k.field_78795_f -= MathHelper.func_76126_a((float)(this.ageInTicks * 0.56f)) * 0.8f * factor;
        return this;
    }

    public PlayerModelTransformer makeArmsMoveDynamically(float factor) {
        if (this.option.isCanceled(AnimationPart.RIGHT_ARM)) {
            return this;
        }
        if (this.option.isCanceled(AnimationPart.LEFT_ARM)) {
            return this;
        }
        this.model.field_178723_h.field_78808_h += MathHelper.func_76134_b((float)(this.ageInTicks * 0.56f)) * 0.8f * factor + 0.05f;
        this.model.field_178724_i.field_78808_h -= MathHelper.func_76134_b((float)(this.ageInTicks * 0.56f)) * 0.8f * factor + 0.05f;
        this.model.field_178723_h.field_78795_f += MathHelper.func_76126_a((float)(this.ageInTicks * 0.56f)) * 0.8f * factor;
        this.model.field_178724_i.field_78795_f -= MathHelper.func_76126_a((float)(this.ageInTicks * 0.56f)) * 0.8f * factor;
        return this;
    }

    public PlayerModelTransformer makeLegsLittleMoving() {
        if (this.option.isCanceled(AnimationPart.RIGHT_LEG)) {
            return this;
        }
        if (this.option.isCanceled(AnimationPart.LEFT_LEG)) {
            return this;
        }
        ModelHelper.func_239101_a_((ModelRenderer)this.model.field_178721_j, (ModelRenderer)this.model.field_178722_k, (float)this.ageInTicks);
        return this;
    }

    public PlayerModelTransformer makeLegsShakingDynamically(float factor) {
        if (this.option.isCanceled(AnimationPart.RIGHT_LEG)) {
            return this;
        }
        if (this.option.isCanceled(AnimationPart.LEFT_LEG)) {
            return this;
        }
        this.model.field_178721_j.field_78808_h += MathHelper.func_76134_b((float)(this.ageInTicks * 0.56f)) * 0.8f * factor + 0.05f;
        this.model.field_178722_k.field_78808_h += MathHelper.func_76134_b((float)(this.ageInTicks * 0.56f)) * 0.8f * factor + 0.05f;
        this.model.field_178721_j.field_78795_f += MathHelper.func_76126_a((float)(this.ageInTicks * 0.56f)) * 0.2f * factor;
        this.model.field_178722_k.field_78795_f -= MathHelper.func_76126_a((float)(this.ageInTicks * 0.56f)) * 0.2f * factor;
        return this;
    }

    public PlayerModelTransformer rotateAdditionallyHeadPitch(float pitchDegree) {
        if (this.option.isCanceled(AnimationPart.HEAD)) {
            return this;
        }
        this.model.field_78116_c.field_78795_f = (float)Math.toRadians(pitchDegree + this.headPitch);
        return this;
    }

    public PlayerModelTransformer rotateHeadPitch(float pitchDegree) {
        if (this.option.isCanceled(AnimationPart.HEAD)) {
            return this;
        }
        this.model.field_78116_c.field_78795_f = (float)Math.toRadians(pitchDegree);
        return this;
    }

    public PlayerModelTransformer rotateAdditionallyHeadYaw(float yawDegree) {
        if (this.option.isCanceled(AnimationPart.HEAD)) {
            return this;
        }
        this.model.field_78116_c.field_78796_g = (float)Math.toRadians(yawDegree + this.netHeadYaw);
        return this;
    }

    public PlayerModelTransformer rotateAdditionallyHeadRoll(float rollDegree) {
        if (this.option.isCanceled(AnimationPart.HEAD)) {
            return this;
        }
        this.model.field_78116_c.field_78808_h = (float)Math.toRadians(rollDegree + this.netHeadYaw);
        return this;
    }

    public PlayerModelTransformer translateRightArm(float xOffset, float yOffset, float zOffset) {
        if (this.option.isCanceled(AnimationPart.RIGHT_ARM)) {
            return this;
        }
        this.getRawModel().field_178723_h.field_78800_c += xOffset;
        this.getRawModel().field_178723_h.field_78797_d += yOffset;
        this.getRawModel().field_178723_h.field_78798_e += zOffset;
        return this;
    }

    public PlayerModelTransformer translateLeftArm(float xOffset, float yOffset, float zOffset) {
        if (this.option.isCanceled(AnimationPart.LEFT_ARM)) {
            return this;
        }
        this.getRawModel().field_178724_i.field_78800_c += xOffset;
        this.getRawModel().field_178724_i.field_78797_d += yOffset;
        this.getRawModel().field_178724_i.field_78798_e += zOffset;
        return this;
    }

    public PlayerModelTransformer translateRightLeg(float xOffset, float yOffset, float zOffset) {
        if (this.option.isCanceled(AnimationPart.RIGHT_LEG)) {
            return this;
        }
        this.getRawModel().field_178721_j.field_78800_c += xOffset;
        this.getRawModel().field_178721_j.field_78797_d += yOffset;
        this.getRawModel().field_178721_j.field_78798_e += zOffset;
        return this;
    }

    public PlayerModelTransformer translateLeftLeg(float xOffset, float yOffset, float zOffset) {
        if (this.option.isCanceled(AnimationPart.LEFT_LEG)) {
            return this;
        }
        this.getRawModel().field_178722_k.field_78800_c += xOffset;
        this.getRawModel().field_178722_k.field_78797_d += yOffset;
        this.getRawModel().field_178722_k.field_78798_e += zOffset;
        return this;
    }

    public PlayerModelTransformer translateHead(float xOffset, float yOffset, float zOffset) {
        if (this.option.isCanceled(AnimationPart.HEAD)) {
            return this;
        }
        this.getRawModel().field_78116_c.field_78800_c += xOffset;
        this.getRawModel().field_78116_c.field_78797_d += yOffset;
        this.getRawModel().field_78116_c.field_78798_e += zOffset;
        return this;
    }

    public void end() {
    }

    public void copyFromBodyToWear() {
        this.model.field_178732_b.func_217177_a(this.model.field_178723_h);
        this.model.field_178734_a.func_217177_a(this.model.field_178724_i);
        this.model.field_178731_d.func_217177_a(this.model.field_178721_j);
        this.model.field_178733_c.func_217177_a(this.model.field_178722_k);
        this.model.field_178730_v.func_217177_a(this.model.field_78115_e);
        this.model.field_178720_f.func_217177_a(this.model.field_78116_c);
    }

    private void setRotations(ModelRenderer renderer, float angleX, float angleY, float angleZ) {
        renderer.field_78795_f = angleX;
        renderer.field_78796_g = angleY;
        renderer.field_78808_h = angleZ;
    }

    public void reset() {
        this.resetModel(this.model.field_78116_c);
        this.resetModel(this.model.field_178720_f);
        this.resetModel(this.model.field_178730_v);
        this.resetModel(this.model.field_78115_e);
        this.resetModel(this.model.field_178723_h);
        this.model.field_178723_h.field_78800_c = -5.0f;
        this.model.field_178723_h.field_78797_d = 2.0f;
        this.model.field_178723_h.field_78798_e = 0.0f;
        this.model.field_178732_b.func_217177_a(this.model.field_178723_h);
        this.resetModel(this.model.field_178724_i);
        this.model.field_178724_i.field_78800_c = 5.0f;
        this.model.field_178724_i.field_78797_d = 2.0f;
        this.model.field_178724_i.field_78798_e = 0.0f;
        this.model.field_178734_a.func_217177_a(this.model.field_178724_i);
        this.resetModel(this.model.field_178722_k);
        this.model.field_178722_k.field_78800_c = 1.9f;
        this.model.field_178722_k.field_78797_d = 12.0f;
        this.model.field_178722_k.field_78798_e = 0.0f;
        this.model.field_178733_c.func_217177_a(this.model.field_178722_k);
        this.resetModel(this.model.field_178721_j);
        this.model.field_178721_j.field_78800_c = -1.9f;
        this.model.field_178721_j.field_78797_d = 12.0f;
        this.model.field_178721_j.field_78798_e = 0.0f;
        this.model.field_178731_d.func_217177_a(this.model.field_178721_j);
    }

    public void resetModel(ModelRenderer model) {
        model.field_78795_f = 0.0f;
        model.field_78796_g = 0.0f;
        model.field_78808_h = 0.0f;
        model.field_78800_c = 0.0f;
        model.field_78797_d = 0.0f;
        model.field_78798_e = 0.0f;
    }
}

