/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.client.animation.impl;

import com.alrex.parcool.client.animation.Animator;
import com.alrex.parcool.client.animation.PlayerModelRotator;
import com.alrex.parcool.client.animation.PlayerModelTransformer;
import com.alrex.parcool.common.action.impl.FastRun;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.config.ParCoolConfig;
import com.alrex.parcool.utilities.BipedModelUtil;
import com.alrex.parcool.utilities.Easing;
import com.alrex.parcool.utilities.MathUtil;
import com.alrex.parcool.utilities.VectorUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.vector.Vector3d;

public class FastRunningAnimator
extends Animator {
    private float limbSwing = 0.0f;

    @Override
    public boolean shouldRemoved(PlayerEntity player, Parkourability parkourability) {
        return !parkourability.get(FastRun.class).isDoing();
    }

    private float bodyAngleFactor(float phase) {
        return new Easing(phase).squareOut(0.0f, 1.0f, 0.0f, 1.0f).get();
    }

    @Override
    public void animatePost(PlayerEntity player, Parkourability parkourability, PlayerModelTransformer transformer) {
        boolean rightArmAnimatable;
        this.limbSwing = transformer.getLimbSwing();
        float phase = ((float)this.getTick() + transformer.getPartialTick()) / 10.0f;
        if (phase > 1.0f) {
            phase = 1.0f;
        }
        float bodyAngleFactor = this.bodyAngleFactor(phase);
        double rightXRotFactor = Math.cos((double)this.limbSwing * 0.6662 + Math.PI);
        double leftXRotFactor = Math.cos((double)this.limbSwing * 0.6662);
        HandSide attackHand = BipedModelUtil.getAttackArm(player);
        boolean leftArmAnimatable = attackHand != HandSide.LEFT || transformer.getRawModel().field_217112_c <= 0.0f;
        boolean bl = rightArmAnimatable = attackHand != HandSide.RIGHT || transformer.getRawModel().field_217112_c <= 0.0f;
        if (leftArmAnimatable && (transformer.getRawModel().field_187075_l != BipedModel.ArmPose.EMPTY && transformer.getRawModel().field_187075_l != BipedModel.ArmPose.ITEM || transformer.getRawModel().field_187076_m.func_241657_a_())) {
            leftArmAnimatable = false;
        }
        if (rightArmAnimatable && (transformer.getRawModel().field_187076_m != BipedModel.ArmPose.EMPTY && transformer.getRawModel().field_187076_m != BipedModel.ArmPose.ITEM || transformer.getRawModel().field_187075_l.func_241657_a_())) {
            rightArmAnimatable = false;
        }
        if (leftArmAnimatable) {
            transformer.translateLeftArm((float)(-Math.abs(leftXRotFactor)), bodyAngleFactor * 0.8f, (float)(leftXRotFactor * 2.0));
        }
        if (rightArmAnimatable) {
            transformer.translateRightArm((float)Math.abs(rightXRotFactor), bodyAngleFactor * 0.8f, (float)(rightXRotFactor * 2.0));
        }
        transformer.translateRightLeg(0.0f, (float)Math.min(0.0, (double)transformer.getRawModel().field_178721_j.field_78795_f / 1.5707963267948966), (float)((double)transformer.getRawModel().field_178721_j.field_78795_f / 1.0471975511965976)).translateLeftLeg(0.0f, (float)Math.min(0.0, (double)transformer.getRawModel().field_178722_k.field_78795_f / 1.5707963267948966), (float)((double)transformer.getRawModel().field_178722_k.field_78795_f / 1.0471975511965976));
        float bodyYaw = (float)(10.0 * Math.cos((double)this.limbSwing * 0.6662));
        float tick = (float)this.getTick() + transformer.getPartialTick();
        if (leftArmAnimatable) {
            transformer.rotateLeftArm((float)(Math.toRadians(-25.0f * bodyAngleFactor) + 1.2 * leftXRotFactor * (double)transformer.getLimbSwingAmount()), 0.0f, (float)Math.toRadians((double)(bodyAngleFactor * -15.0f) + (0.65 + Math.cos((double)this.limbSwing * 1.3324)) / 2.0 * Math.sin((double)this.limbSwing * 1.3324) * -30.0));
        }
        if (rightArmAnimatable) {
            transformer.rotateRightArm((float)(Math.toRadians(-25.0f * bodyAngleFactor) + 1.2 * rightXRotFactor * (double)transformer.getLimbSwingAmount()), 0.0f, (float)Math.toRadians((double)(bodyAngleFactor * 15.0f) + (0.65 + Math.cos((double)this.limbSwing * 1.3324 + Math.PI)) / 2.0 * Math.sin((double)this.limbSwing * 1.3324 + Math.PI) * 30.0));
        }
        transformer.rotateAdditionallyHeadPitch(bodyAngleFactor * -30.0f - 5.0f * (float)Math.sin(Math.PI * (double)tick / 10.0)).rotateAdditionallyHeadYaw(bodyYaw).addRotateRightLeg((float)Math.toRadians(-15.0f * bodyAngleFactor), (float)Math.toRadians(bodyYaw), 0.0f).addRotateLeftLeg((float)Math.toRadians(-15.0f * bodyAngleFactor), (float)Math.toRadians(bodyYaw), 0.0f).end();
    }

    @Override
    public void rotatePost(PlayerEntity player, Parkourability parkourability, PlayerModelRotator rotator) {
        float tick = (float)this.getTick() + rotator.getPartialTick();
        float phase = tick / 10.0f;
        if (phase > 1.0f) {
            phase = 1.0f;
        }
        float bodyYaw = (float)(-10.0 * Math.cos((double)this.limbSwing * 0.6662));
        float pitch = this.bodyAngleFactor(phase) * 30.0f + 5.0f * (float)Math.sin(Math.PI * (double)tick / 10.0);
        if (parkourability.getClientInfo().get(ParCoolConfig.Client.Booleans.EnableLeanAnimationOfFastRun).booleanValue()) {
            if (player.func_175144_cb() && Minecraft.func_71410_x().field_71462_r != null) {
                rotator.startBasedCenter().rotatePitchFrontward(pitch).end();
            } else {
                Vector3d lookAngle = player.func_70040_Z();
                Vector3d bodyAngle = VectorUtil.fromYawDegree(MathUtil.lerp(player.field_70760_ar, player.field_70761_aq, rotator.getPartialTick()));
                Vector3d differenceVec = new Vector3d(lookAngle.func_82615_a() * bodyAngle.func_82615_a() + lookAngle.func_82616_c() * bodyAngle.func_82616_c(), 0.0, -lookAngle.func_82615_a() * bodyAngle.func_82616_c() + lookAngle.func_82616_c() * bodyAngle.func_82615_a()).func_72432_b();
                rotator.startBasedCenter().rotatePitchFrontward(pitch).rotateYawRightward(bodyYaw).rotateRollRightward((float)(30.0 * (double)phase * Math.asin(differenceVec.func_82616_c()))).end();
            }
        } else {
            rotator.startBasedCenter().rotatePitchFrontward(pitch).end();
        }
    }
}

