/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.client.animation.impl;

import com.alrex.parcool.client.animation.Animator;
import com.alrex.parcool.client.animation.PlayerModelRotator;
import com.alrex.parcool.client.animation.PlayerModelTransformer;
import com.alrex.parcool.common.action.impl.FastSwim;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.utilities.BipedModelUtil;
import com.alrex.parcool.utilities.MathUtil;
import com.alrex.parcool.utilities.VectorUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.vector.Vector3d;

public class FastSwimAnimator
extends Animator {
    @Override
    public boolean shouldRemoved(PlayerEntity player, Parkourability parkourability) {
        return !parkourability.get(FastSwim.class).isDoing();
    }

    @Override
    public void animatePost(PlayerEntity player, Parkourability parkourability, PlayerModelTransformer transformer) {
        double leftArmXAngle;
        double rightArmXAngle;
        boolean rightArmAnimatable;
        float animationFactor = ((float)this.getTick() + transformer.getPartialTick()) / 10.0f;
        if (animationFactor > 1.0f) {
            animationFactor = 1.0f;
        }
        float tick = (float)this.getTick() + transformer.getPartialTick();
        double armFactor = Math.cos(Math.PI * (double)tick / 15.0);
        HandSide attackHand = BipedModelUtil.getAttackArm(player);
        boolean leftArmAnimatable = attackHand != HandSide.LEFT || transformer.getRawModel().field_217112_c <= 0.0f;
        boolean bl = rightArmAnimatable = attackHand != HandSide.RIGHT || transformer.getRawModel().field_217112_c <= 0.0f;
        if (leftArmAnimatable && (transformer.getRawModel().field_187075_l != BipedModel.ArmPose.EMPTY && transformer.getRawModel().field_187075_l != BipedModel.ArmPose.ITEM || transformer.getRawModel().field_187076_m.func_241657_a_())) {
            leftArmAnimatable = false;
        }
        if (rightArmAnimatable && (transformer.getRawModel().field_187076_m != BipedModel.ArmPose.EMPTY && transformer.getRawModel().field_187076_m != BipedModel.ArmPose.ITEM || transformer.getRawModel().field_187075_l.func_241657_a_())) {
            rightArmAnimatable = false;
        }
        if ((rightArmXAngle = -(leftArmXAngle = 45.0 * armFactor)) < 0.0) {
            rightArmXAngle = -3.0 * Math.sqrt(-rightArmXAngle);
        }
        if (leftArmXAngle < 0.0) {
            leftArmXAngle = -3.0 * Math.sqrt(-leftArmXAngle);
        }
        if (rightArmAnimatable) {
            transformer.translateRightArm((float)Math.max(0.0, 2.4 * Math.sin(Math.PI * (double)tick / 15.0)), (float)Math.max(0.0, 1.2 * Math.sin(Math.PI * (double)tick / 15.0)), (float)(-1.2 * Math.sin(Math.PI * (double)tick / 15.0)));
        }
        if (leftArmAnimatable) {
            transformer.translateLeftArm(-((float)Math.max(0.0, -2.4 * Math.sin(Math.PI * (double)tick / 15.0))), (float)Math.max(0.0, -1.2 * Math.sin(Math.PI * (double)tick / 15.0)), (float)(1.2 * Math.sin(Math.PI * (double)tick / 15.0)));
        }
        transformer.translateHead(0.0f, 0.0f, 0.5f * animationFactor).rotateAdditionallyHeadYaw((float)(-5.0 * Math.sin(Math.PI * (double)tick / 15.0))).rotateRightArm((float)Math.toRadians(-190.0 + rightArmXAngle), 0.0f, (float)Math.toRadians(-40.0 + 50.0 * Math.sin(Math.PI * (double)tick / 15.0))).rotateLeftArm((float)Math.toRadians(-190.0 + leftArmXAngle), 0.0f, (float)Math.toRadians(40.0 + 50.0 * Math.sin(Math.PI * (double)tick / 15.0)));
        if (rightArmAnimatable) {
            transformer.rotateRightLeg((float)Math.toRadians(-40.0 * Math.cos(Math.PI * (double)tick / 9.0)), 0.0f, 0.0f, animationFactor);
        }
        if (leftArmAnimatable) {
            transformer.rotateLeftLeg((float)Math.toRadians(40.0 * Math.cos(Math.PI * (double)tick / 9.0)), 0.0f, 0.0f, animationFactor);
        }
        transformer.end();
    }

    @Override
    public void rotatePost(PlayerEntity player, Parkourability parkourability, PlayerModelRotator rotator) {
        if (player.func_175144_cb() && Minecraft.func_71410_x().field_71462_r != null) {
            return;
        }
        float tick = (float)this.getTick() + rotator.getPartialTick();
        Vector3d lookAngle = player.func_70040_Z();
        Vector3d bodyAngle = VectorUtil.fromYawDegree(MathUtil.lerp(player.field_70760_ar, player.field_70761_aq, rotator.getPartialTick()));
        Vector3d differenceVec = new Vector3d(lookAngle.func_82615_a() * bodyAngle.func_82615_a() + lookAngle.func_82616_c() * bodyAngle.func_82616_c(), 0.0, -lookAngle.func_82615_a() * bodyAngle.func_82616_c() + lookAngle.func_82616_c() * bodyAngle.func_82615_a()).func_72432_b();
        rotator.startBasedCenter().rotateYawRightward((float)(-15.0 * Math.asin(differenceVec.func_82616_c()) + 12.0 * Math.sin(Math.PI * (double)tick / 15.0))).end();
    }
}

