/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.client.animation.impl;

import com.alrex.parcool.client.animation.Animator;
import com.alrex.parcool.client.animation.PlayerModelRotator;
import com.alrex.parcool.client.animation.PlayerModelTransformer;
import com.alrex.parcool.common.action.impl.HorizontalWallRun;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.config.ParCoolConfig;
import com.alrex.parcool.utilities.MathUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.client.event.EntityViewRenderEvent;

public class HorizontalWallRunAnimator
extends Animator {
    final boolean wallIsRightSide;

    public HorizontalWallRunAnimator(boolean wallIsRightSide) {
        this.wallIsRightSide = wallIsRightSide;
    }

    @Override
    public boolean shouldRemoved(PlayerEntity player, Parkourability parkourability) {
        return !parkourability.get(HorizontalWallRun.class).isDoing();
    }

    @Override
    public void animatePost(PlayerEntity player, Parkourability parkourability, PlayerModelTransformer transformer) {
        if (this.wallIsRightSide) {
            transformer.addRotateLeftArm(0.0f, 0.0f, (float)Math.toRadians(-30.0)).makeArmsNatural().rotateRightArm(0.0f, 0.0f, (float)Math.toRadians(60.0)).addRotateRightLeg(0.0f, 0.0f, (float)Math.toRadians(17.0)).addRotateLeftLeg(0.0f, 0.0f, (float)Math.toRadians(25.0)).end();
        } else {
            transformer.addRotateRightArm(0.0f, 0.0f, (float)Math.toRadians(30.0)).makeArmsNatural().rotateLeftArm(0.0f, 0.0f, (float)Math.toRadians(-60.0)).addRotateRightLeg(0.0f, 0.0f, (float)Math.toRadians(-25.0)).addRotateLeftLeg(0.0f, 0.0f, (float)Math.toRadians(-17.0)).end();
        }
    }

    private float getFactor(float tick) {
        return tick < 5.0f ? 1.0f - MathUtil.squaring((5.0f - tick) / 5.0f) : 1.0f;
    }

    @Override
    public void rotatePost(PlayerEntity player, Parkourability parkourability, PlayerModelRotator rotator) {
        float factor = this.getFactor((float)this.getTick() + rotator.getPartialTick());
        float angle = factor * 30.0f * (float)(this.wallIsRightSide ? -1 : 1);
        rotator.startBasedCenter().rotateRollRightward(angle).end();
    }

    @Override
    public void onCameraSetUp(EntityViewRenderEvent.CameraSetup event, PlayerEntity clientPlayer, Parkourability parkourability) {
        if (!Minecraft.func_71410_x().field_71474_y.func_243230_g().func_243192_a() || !ParCoolConfig.Client.Booleans.EnableCameraAnimationOfHWallRun.get().booleanValue()) {
            return;
        }
        float factor = this.getFactor((float)((double)this.getTick() + event.getRenderPartialTicks()));
        float angle = factor * 20.0f * (float)(this.wallIsRightSide ? -1 : 1);
        event.setRoll(angle);
    }
}

