/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.client.animation.impl;

import com.alrex.parcool.client.animation.Animator;
import com.alrex.parcool.client.animation.PlayerModelRotator;
import com.alrex.parcool.client.animation.PlayerModelTransformer;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.config.ParCoolConfig;
import com.alrex.parcool.utilities.Easing;
import com.alrex.parcool.utilities.EasingFunctions;
import com.alrex.parcool.utilities.MathUtil;
import com.alrex.parcool.utilities.VectorUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.client.event.EntityViewRenderEvent;

public class KongVaultAnimator
extends Animator {
    private float yRotDifference = 0.0f;
    private float yRotDifferenceOld = 0.0f;

    float getFactor(float phase) {
        if ((double)phase < 0.5) {
            return EasingFunctions.SinInOutBySquare(phase * 2.0f);
        }
        return EasingFunctions.SinInOutBySquare(2.0f - phase * 2.0f);
    }

    float getArmFactor(float phase) {
        return (double)phase < 0.2 ? 1.0f - 25.0f * (phase - 0.2f) * (phase - 0.2f) : 1.0f - EasingFunctions.SinInOutBySquare((phase - 0.2f) * 1.25f);
    }

    @Override
    public void tick(PlayerEntity player) {
        super.tick(player);
        this.yRotDifferenceOld = this.yRotDifference;
        Vector3d currentAngle = VectorUtil.fromYawDegree(player.field_70761_aq);
        Vector3d oldAngle = VectorUtil.fromYawDegree(player.field_70760_ar);
        this.yRotDifference = (float)Math.atan((oldAngle.func_82615_a() * currentAngle.func_82616_c() - currentAngle.func_82615_a() * oldAngle.func_82616_c()) / (currentAngle.func_82615_a() * oldAngle.func_82615_a() + currentAngle.func_82616_c() * oldAngle.func_82616_c()));
    }

    @Override
    public boolean shouldRemoved(PlayerEntity player, Parkourability parkourability) {
        return this.getTick() >= 11;
    }

    @Override
    public void animatePost(PlayerEntity player, Parkourability parkourability, PlayerModelTransformer transformer) {
        float phase = ((float)this.getTick() + transformer.getPartialTick()) / 11.0f;
        float armFactor = this.getArmFactor(phase);
        float factor = this.getFactor(phase);
        float animFactor = new Easing(phase).sinInOut(0.0f, 0.15f, 0.0f, 1.0f).linear(0.15f, 0.85f, 1.0f, 1.0f).sinInOut(0.85f, 1.0f, 1.0f, 0.0f).get();
        float difference = MathUtil.lerp(this.yRotDifferenceOld, this.yRotDifference, transformer.getPartialTick());
        transformer.translateLeftLeg(0.0f, -0.7f * factor, -0.9f * factor).translateRightLeg(0.0f, -0.7f * factor, -0.9f * factor).rotateAdditionallyHeadPitch(-40.0f * armFactor).rotateRightArm((float)Math.toRadians(30.0f - 195.0f * armFactor), 0.0f, (float)Math.toRadians(30.0f - 30.0f * armFactor), animFactor).rotateLeftArm((float)Math.toRadians(25.0f - 195.0f * armFactor), 0.0f, (float)Math.toRadians(-30.0f + 30.0f * armFactor), animFactor).rotateRightLeg((float)Math.toRadians(Easing.with(phase).squareOut(0.0f, 0.1f, 5.0f, -5.0f).sinInOut(0.1f, 0.47f, -5.0f, 25.0f).sinInOut(0.47f, 0.9f, 25.0f, -25.0f).sinInOut(0.9f, 1.0f, -25.0f, 0.0f).get()), 0.0f, difference - (float)Math.toRadians(5.0 * (double)factor), animFactor).rotateLeftLeg((float)Math.toRadians(Easing.with(phase).sinInOut(0.0f, 0.33f, -20.0f, 20.0f).sinInOut(0.33f, 0.79f, 20.0f, -45.0f).sinInOut(0.79f, 1.0f, -45.0f, 0.0f).get()), 0.0f, difference + (float)Math.toRadians(5.0 * (double)factor), animFactor).makeLegsLittleMoving().end();
    }

    @Override
    public void rotatePost(PlayerEntity player, Parkourability parkourability, PlayerModelRotator rotator) {
        float phase = ((float)this.getTick() + rotator.getPartialTick()) / 11.0f;
        float factor = this.getFactor(phase);
        float yFactor = new Easing(phase).squareOut(0.0f, 0.5f, 0.0f, 1.0f).squareIn(0.5f, 1.0f, 1.0f, 0.0f).get();
        rotator.startBasedCenter().translateY(-yFactor * player.func_213302_cg() / 5.0f).rotatePitchFrontward(factor * 95.0f).end();
    }

    @Override
    public void onCameraSetUp(EntityViewRenderEvent.CameraSetup event, PlayerEntity clientPlayer, Parkourability parkourability) {
        if (!Minecraft.func_71410_x().field_71474_y.func_243230_g().func_243192_a() || !ParCoolConfig.Client.Booleans.EnableCameraAnimationOfVault.get().booleanValue()) {
            return;
        }
        float phase = (float)(((double)this.getTick() + event.getRenderPartialTicks()) / 11.0);
        float factor = this.getFactor(phase);
        event.setPitch(30.0f * factor + clientPlayer.func_195050_f((float)event.getRenderPartialTicks()));
    }
}

