/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.client.gui;

import com.alrex.parcool.client.gui.ColorTheme;
import com.alrex.parcool.client.gui.SettingActionLimitationScreen;
import com.alrex.parcool.client.gui.SettingBooleanConfigScreen;
import com.alrex.parcool.client.gui.SettingEnumConfigScreen;
import com.alrex.parcool.client.gui.SettingShowLimitationsScreen;
import com.alrex.parcool.common.info.ActionInfo;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Arrays;
import java.util.Collections;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public abstract class ParCoolSettingScreen
extends Screen {
    private final ScreenSet<?>[] screenList;
    protected int currentScreen = 0;
    protected int topIndex = 0;
    protected int viewableItemCount = 0;
    protected static final int Checkbox_Item_Height = 21;
    protected final ColorTheme color;
    protected final BooleanSupplier serverPermissionReceived = info.getServerLimitation()::isSynced;
    private static final ITextComponent MenuTitle = new TranslationTextComponent("parcool.gui.title.setting");
    protected static final ITextComponent Header_ActionName = new TranslationTextComponent("parcool.gui.text.actionName");
    protected static final ITextComponent Header_Limitation = new StringTextComponent("L");
    protected static final ITextComponent Header_Limitation_Text = new TranslationTextComponent("parcool.gui.text.limitation");
    protected static final ITextComponent Permission_Permitted = new StringTextComponent("\u2713");
    protected static final ITextComponent Permission_Denied = new StringTextComponent("\u00d7");
    protected static final ITextComponent Permission_Not_Received = new StringTextComponent("\u00a74[Error] Permissions are not sent from a server.\n\nBy closing this setting menu, permissions will be sent again.\nIf it were not done, please report to the mod developer after checking whether ParCool is installed and re-login to the server.\u00a7r");

    public ParCoolSettingScreen(ITextComponent titleIn, ActionInfo info, ColorTheme theme) {
        super(titleIn);
        this.color = theme;
        this.screenList = new ScreenSet[]{new ScreenSet<SettingActionLimitationScreen>((ITextComponent)new TranslationTextComponent("parcool.gui.text.action"), () -> new SettingActionLimitationScreen(this.field_230704_d_, info, theme)), new ScreenSet<SettingBooleanConfigScreen>((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"parcool.gui.text.config", (Object[])new Object[0]) + "1"), () -> new SettingBooleanConfigScreen(titleIn, info, theme)), new ScreenSet<SettingEnumConfigScreen>((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"parcool.gui.text.config", (Object[])new Object[0]) + "2"), () -> new SettingEnumConfigScreen(titleIn, info, theme)), new ScreenSet<SettingShowLimitationsScreen>((ITextComponent)new TranslationTextComponent("parcool.gui.text.limitation"), () -> new SettingShowLimitationsScreen(titleIn, info, theme))};
    }

    public void func_231152_a_(@Nonnull Minecraft minecraft, int p_231152_2_, int p_231152_3_) {
        super.func_231152_a_(minecraft, p_231152_2_, p_231152_3_);
        this.func_231043_a_(0.0, 0.0, 0.0);
    }

    public void func_230430_a_(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float p_230430_4_) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, p_230430_4_);
        this.func_238651_a_(matrixStack, 0);
        this.field_230712_o_.getClass();
        int topBarHeight = 9 * 2;
        int topBarItemWidth = (int)(1.2 * (double)Arrays.stream(this.screenList).map(it -> this.field_230712_o_.func_238414_a_((ITextProperties)it.title)).max(Integer::compareTo).orElse(0).intValue());
        int topBarOffsetX = this.field_230708_k_ - topBarItemWidth * this.screenList.length;
        this.func_238468_a_(matrixStack, 0, 0, this.field_230708_k_, topBarHeight, this.color.getTopBar1(), this.color.getTopBar2());
        this.renderSubHeaderAndFooter(matrixStack, this.screenList[this.currentScreen].title, this.isDownScrollable(), topBarHeight);
        this.field_230712_o_.getClass();
        this.field_230712_o_.getClass();
        this.renderContents(matrixStack, mouseX, mouseY, p_230430_4_, topBarHeight + 9 * 2, 9 * 2);
        for (int i = 0; i < this.screenList.length; ++i) {
            ScreenSet<?> item = this.screenList[i];
            item.y = 0;
            item.x = topBarOffsetX + i * topBarItemWidth;
            item.width = topBarItemWidth;
            item.height = topBarHeight;
            boolean selected = this.currentScreen == i || item.isMouseIn(mouseX, mouseY);
            ParCoolSettingScreen.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)item.title, (int)(topBarOffsetX + i * topBarItemWidth + topBarItemWidth / 2), (int)(topBarHeight / 4 + 1), (int)(selected ? this.color.getText() : this.color.getSubText()));
            ParCoolSettingScreen.func_238467_a_((MatrixStack)matrixStack, (int)item.x, (int)2, (int)(item.x + 1), (int)(topBarHeight - 3), (int)this.color.getSeparator());
        }
        ParCoolSettingScreen.func_238467_a_((MatrixStack)matrixStack, (int)0, (int)(topBarHeight - 1), (int)this.field_230708_k_, (int)topBarHeight, (int)this.color.getSeparator());
        int titleOffset = 0;
        if (!this.serverPermissionReceived.getAsBoolean()) {
            ParCoolSettingScreen.func_238467_a_((MatrixStack)matrixStack, (int)2, (int)2, (int)(topBarHeight - 3), (int)(topBarHeight - 3), (int)-1118482);
            ParCoolSettingScreen.func_238467_a_((MatrixStack)matrixStack, (int)3, (int)3, (int)(topBarHeight - 4), (int)(topBarHeight - 4), (int)-1179648);
            int n = topBarHeight / 2;
            this.field_230712_o_.getClass();
            ParCoolSettingScreen.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)"!", (int)n, (int)((topBarHeight - 9) / 2 + 1), (int)0xEEEEEE);
            if (2 <= mouseX && mouseX < topBarHeight - 3 && 1 <= mouseY && mouseY < topBarHeight - 3) {
                this.func_243308_b(matrixStack, Collections.singletonList(Permission_Not_Received), mouseX, mouseY);
            }
            titleOffset = topBarHeight;
        }
        ParCoolSettingScreen.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)MenuTitle, (int)(titleOffset + 5), (int)(topBarHeight / 4 + 1), (int)this.color.getText());
    }

    protected abstract void renderContents(MatrixStack var1, int var2, int var3, float var4, int var5, int var6);

    protected void save() {
    }

    protected boolean isDownScrollable() {
        return false;
    }

    private void renderSubHeaderAndFooter(MatrixStack matrixStack, ITextComponent title, boolean scrollable, int topOffset) {
        this.field_230712_o_.getClass();
        int headerHeight = 9 * 2;
        this.func_238468_a_(matrixStack, 0, topOffset, this.field_230708_k_, topOffset + headerHeight, this.color.getHeader1(), this.color.getHeader2());
        this.func_238468_a_(matrixStack, 0, this.field_230709_l_ - headerHeight, this.field_230708_k_, this.field_230709_l_, this.color.getHeader1(), this.color.getHeader2());
        int n = this.field_230708_k_ / 2;
        this.field_230712_o_.getClass();
        ParCoolSettingScreen.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)title, (int)n, (int)(topOffset + 9 / 2 + 2), (int)this.color.getStrongText());
        if (scrollable) {
            StringTextComponent stringTextComponent = new StringTextComponent("\u2193");
            int n2 = this.field_230708_k_ / 2;
            this.field_230712_o_.getClass();
            this.field_230712_o_.getClass();
            ParCoolSettingScreen.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)stringTextComponent, (int)n2, (int)(this.field_230709_l_ - 9 - 9 / 2), (int)this.color.getStrongText());
        }
    }

    public void func_238651_a_(@Nonnull MatrixStack p_238651_1_, int p_238651_2_) {
        ParCoolSettingScreen.func_238467_a_((MatrixStack)p_238651_1_, (int)0, (int)0, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)this.color.getBackground());
        MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.BackgroundDrawnEvent((Screen)this, p_238651_1_));
    }

    public void func_231175_as__() {
        this.save();
        super.func_231175_as__();
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        switch (keyCode) {
            case 262: {
                this.save();
                Minecraft.func_71410_x().func_147108_a((Screen)this.screenList[(this.currentScreen + 1) % this.screenList.length].screenSupplier.get());
                break;
            }
            case 263: {
                this.save();
                Minecraft.func_71410_x().func_147108_a((Screen)this.screenList[(this.currentScreen - 1) % this.screenList.length].screenSupplier.get());
                break;
            }
            case 265: {
                this.func_231043_a_(0.0, 0.0, 1.0);
                break;
            }
            case 264: {
                this.func_231043_a_(0.0, 0.0, -1.0);
            }
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_231043_a_(double x, double y, double value) {
        int scroll = (int)(-Math.signum(value));
        if (scroll <= 0 || this.isDownScrollable()) {
            this.topIndex += scroll;
        }
        if (this.topIndex < 0) {
            this.topIndex = 0;
        }
        return true;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int type) {
        for (ScreenSet<?> modeSet : this.screenList) {
            if (!modeSet.isMouseIn((int)mouseX, (int)mouseY) || type != 0) continue;
            this.save();
            Minecraft.func_71410_x().func_147108_a((Screen)modeSet.screenSupplier.get());
            return true;
        }
        return false;
    }

    private static class ScreenSet<T extends ParCoolSettingScreen> {
        final Supplier<T> screenSupplier;
        final ITextComponent title;
        int x;
        int y;
        int width;
        int height;

        boolean isMouseIn(double mouseX, double mouseY) {
            return (double)this.x < mouseX && mouseX < (double)(this.x + this.width) && (double)this.y < mouseY && mouseY < (double)(this.y + this.height);
        }

        public ScreenSet(ITextComponent title, Supplier<T> supplier) {
            this.title = title;
            this.screenSupplier = supplier;
        }
    }
}

