/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.client.gui;

import com.alrex.parcool.client.gui.ColorTheme;
import com.alrex.parcool.client.gui.ParCoolSettingScreen;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.ActionList;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.common.info.ActionInfo;
import com.alrex.parcool.common.info.ClientSetting;
import com.alrex.parcool.common.network.SyncClientInformationMessage;
import com.alrex.parcool.config.ParCoolConfig;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collections;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.CheckboxButton;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.ForgeConfigSpec;

public class SettingActionLimitationScreen
extends ParCoolSettingScreen {
    private final ActionConfigSet[] actionList = new ActionConfigSet[ActionList.ACTIONS.size()];
    private final CheckboxButton[] actionButtons = new CheckboxButton[this.actionList.length];

    public SettingActionLimitationScreen(ITextComponent titleIn, ActionInfo info, ColorTheme theme) {
        super(titleIn, info, theme);
        this.currentScreen = 0;
        for (int i = 0; i < this.actionList.length; ++i) {
            this.actionList[i] = new ActionConfigSet(ActionList.getByIndex(i), info);
            this.actionButtons[i] = new CheckboxButton(0, 0, 0, 21, (ITextComponent)new StringTextComponent(this.actionList[i].name), this.actionList[i].getter.getAsBoolean());
        }
    }

    @Override
    public boolean isDownScrollable() {
        return this.topIndex + this.viewableItemCount < this.actionButtons.length;
    }

    @Override
    public void renderContents(MatrixStack matrixStack, int mouseX, int mouseY, float partialTick, int topOffset, int bottomOffset) {
        int offsetX = 40;
        this.field_230712_o_.getClass();
        int headerHeight = (int)(9.0f * 1.5f);
        int contentOffsetY = topOffset + headerHeight + 2;
        int permissionColumnWidth = this.field_230712_o_.func_238414_a_((ITextProperties)Permission_Permitted) * 5;
        int nameColumnWidth = this.field_230708_k_ - 80 - permissionColumnWidth;
        int contentHeight = this.field_230709_l_ - contentOffsetY - bottomOffset;
        this.viewableItemCount = contentHeight / 21;
        int n = topOffset + headerHeight / 2;
        this.field_230712_o_.getClass();
        int headerTextY = n - 9 / 2 + 1;
        SettingActionLimitationScreen.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)Header_ActionName, (int)45, (int)headerTextY, (int)this.color.getText());
        SettingActionLimitationScreen.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)Header_Limitation, (int)(40 + nameColumnWidth + permissionColumnWidth / 2), (int)headerTextY, (int)this.color.getText());
        for (CheckboxButton actionButton : this.actionButtons) {
            actionButton.func_230991_b_(0);
        }
        SettingActionLimitationScreen.func_238467_a_((MatrixStack)matrixStack, (int)40, (int)contentOffsetY, (int)(this.field_230708_k_ - 40), (int)(contentOffsetY - 1), (int)this.color.getSeparator());
        SettingActionLimitationScreen.func_238467_a_((MatrixStack)matrixStack, (int)40, (int)topOffset, (int)41, (int)(this.field_230709_l_ - bottomOffset), (int)this.color.getSeparator());
        SettingActionLimitationScreen.func_238467_a_((MatrixStack)matrixStack, (int)(40 + nameColumnWidth), (int)topOffset, (int)(40 + nameColumnWidth + 1), (int)(this.field_230709_l_ - bottomOffset), (int)this.color.getSeparator());
        SettingActionLimitationScreen.func_238467_a_((MatrixStack)matrixStack, (int)(40 + nameColumnWidth + permissionColumnWidth), (int)topOffset, (int)(40 + nameColumnWidth + permissionColumnWidth + 1), (int)(this.field_230709_l_ - bottomOffset), (int)this.color.getSeparator());
        for (int i = 0; i < this.viewableItemCount && i + this.topIndex < this.actionButtons.length; ++i) {
            CheckboxButton button = this.actionButtons[i + this.topIndex];
            button.field_230690_l_ = 41;
            button.field_230691_m_ = contentOffsetY + 21 * i;
            button.func_230991_b_(nameColumnWidth - 5);
            button.setHeight(20);
            button.func_230430_a_(matrixStack, mouseX, mouseY, partialTick);
            SettingActionLimitationScreen.func_238467_a_((MatrixStack)matrixStack, (int)40, (int)(button.field_230691_m_ + button.func_238483_d_()), (int)(this.field_230708_k_ - 40), (int)(button.field_230691_m_ + button.func_238483_d_() + 1), (int)this.color.getSubSeparator());
            int rowY = contentOffsetY + 21 * i + 10;
            boolean permitted = this.actionList[this.topIndex + i].serverLimitation.getAsBoolean();
            ITextComponent iTextComponent = permitted ? Permission_Permitted : Permission_Denied;
            int n2 = 40 + nameColumnWidth + permissionColumnWidth / 2;
            this.field_230712_o_.getClass();
            SettingActionLimitationScreen.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)iTextComponent, (int)n2, (int)(rowY - 9 / 2), (int)(permitted ? 43520 : 0xAA0000));
        }
        int columnCenter = 40 + nameColumnWidth + permissionColumnWidth / 2;
        if (topOffset < mouseY && mouseY < topOffset + headerHeight && columnCenter - permissionColumnWidth / 2 < mouseX && mouseX < columnCenter + permissionColumnWidth / 2) {
            this.func_243308_b(matrixStack, Collections.singletonList(Header_Limitation_Text), mouseX, mouseY);
        }
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int type) {
        for (CheckboxButton button : this.actionButtons) {
            if (!button.func_231044_a_(mouseX, mouseY, type)) continue;
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, type);
    }

    @Override
    protected void save() {
        for (int i = 0; i < this.actionList.length; ++i) {
            this.actionList[i].setter.accept(this.actionButtons[i].func_212942_a());
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        Parkourability parkourability = Parkourability.get((PlayerEntity)player);
        if (parkourability == null) {
            return;
        }
        parkourability.getActionInfo().setClientSetting(ClientSetting.readFromLocalConfig());
        SyncClientInformationMessage.sync(player, true);
    }

    private static class ActionConfigSet {
        final String name;
        final Consumer<Boolean> setter;
        final BooleanSupplier getter;
        final BooleanSupplier serverLimitation;

        ActionConfigSet(Class<? extends Action> action, ActionInfo info) {
            this.name = new TranslationTextComponent("parcool.action." + action.getSimpleName()).getString();
            ForgeConfigSpec.BooleanValue config = ParCoolConfig.Client.getPossibilityOf(action);
            this.setter = arg_0 -> ((ForgeConfigSpec.BooleanValue)config).set(arg_0);
            this.getter = () -> ((ForgeConfigSpec.BooleanValue)config).get();
            this.serverLimitation = () -> info.getServerLimitation().isPermitted(action);
        }
    }
}

