/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.client.gui;

import com.alrex.parcool.client.gui.ColorTheme;
import com.alrex.parcool.client.gui.ParCoolSettingScreen;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.common.info.ActionInfo;
import com.alrex.parcool.common.info.ClientSetting;
import com.alrex.parcool.common.network.SyncClientInformationMessage;
import com.alrex.parcool.config.ParCoolConfig;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.widget.button.CheckboxButton;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class SettingBooleanConfigScreen
extends ParCoolSettingScreen {
    private final ParCoolConfig.Client.Booleans[] booleans = ParCoolConfig.Client.Booleans.values();
    private final CheckboxButton[] configButtons = new CheckboxButton[this.booleans.length];

    public SettingBooleanConfigScreen(ITextComponent titleIn, ActionInfo info, ColorTheme theme) {
        super(titleIn, info, theme);
        this.currentScreen = 1;
        for (int i = 0; i < this.booleans.length; ++i) {
            this.configButtons[i] = new CheckboxButton(0, 0, 0, 21, (ITextComponent)new TranslationTextComponent(this.booleans[i].Path), this.booleans[i].get().booleanValue());
        }
    }

    @Override
    protected boolean isDownScrollable() {
        return this.topIndex + this.viewableItemCount < this.configButtons.length;
    }

    @Override
    protected void renderContents(MatrixStack matrixStack, int mouseX, int mouseY, float partialTick, int topOffset, int bottomOffset) {
        int offsetX = 40;
        int contentWidth = this.field_230708_k_ - 80;
        int contentHeight = this.field_230709_l_ - topOffset - bottomOffset;
        this.viewableItemCount = contentHeight / 21;
        for (CheckboxButton configButton : this.configButtons) {
            configButton.func_230991_b_(0);
        }
        for (int i = 0; i < this.viewableItemCount && i + this.topIndex < this.booleans.length; ++i) {
            CheckboxButton button = this.configButtons[i + this.topIndex];
            button.field_230690_l_ = 41;
            button.field_230691_m_ = topOffset + 21 * i;
            button.func_230991_b_(contentWidth);
            button.setHeight(20);
            button.func_230430_a_(matrixStack, mouseX, mouseY, partialTick);
            SettingBooleanConfigScreen.func_238467_a_((MatrixStack)matrixStack, (int)40, (int)(button.field_230691_m_ + button.func_238483_d_()), (int)(this.field_230708_k_ - 40), (int)(button.field_230691_m_ + button.func_238483_d_() + 1), (int)this.color.getSubSeparator());
            String comment = this.booleans[i + this.topIndex].Comment;
            if (comment == null || button.field_230690_l_ >= mouseX || mouseX >= button.field_230690_l_ + contentWidth || button.field_230691_m_ >= mouseY || mouseY >= button.field_230691_m_ + 20) continue;
            this.func_243308_b(matrixStack, Collections.singletonList(new StringTextComponent(comment)), mouseX, mouseY);
        }
        SettingBooleanConfigScreen.func_238467_a_((MatrixStack)matrixStack, (int)(this.field_230708_k_ - 40), (int)topOffset, (int)(this.field_230708_k_ - 40 - 1), (int)(topOffset + contentHeight), (int)this.color.getSeparator());
        SettingBooleanConfigScreen.func_238467_a_((MatrixStack)matrixStack, (int)40, (int)topOffset, (int)41, (int)(topOffset + contentHeight), (int)this.color.getSeparator());
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int type) {
        for (CheckboxButton button : this.configButtons) {
            if (!button.func_231044_a_(mouseX, mouseY, type)) continue;
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, type);
    }

    @Override
    public void func_231175_as__() {
        super.func_231175_as__();
    }

    @Override
    protected void save() {
        for (int i = 0; i < this.booleans.length; ++i) {
            this.booleans[i].set(this.configButtons[i].func_212942_a());
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        Parkourability parkourability = Parkourability.get((PlayerEntity)player);
        if (parkourability == null) {
            return;
        }
        parkourability.getActionInfo().setClientSetting(ClientSetting.readFromLocalConfig());
        SyncClientInformationMessage.sync(player, true);
    }
}

