/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.client.gui;

import com.alrex.parcool.client.gui.ColorTheme;
import com.alrex.parcool.client.gui.ParCoolSettingScreen;
import com.alrex.parcool.client.hud.Position;
import com.alrex.parcool.client.hud.impl.HUDType;
import com.alrex.parcool.common.action.impl.Crawl;
import com.alrex.parcool.common.action.impl.FastRun;
import com.alrex.parcool.common.action.impl.Flipping;
import com.alrex.parcool.common.action.impl.HorizontalWallRun;
import com.alrex.parcool.common.action.impl.Vault;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.common.info.ActionInfo;
import com.alrex.parcool.common.info.ClientSetting;
import com.alrex.parcool.common.network.SyncClientInformationMessage;
import com.alrex.parcool.config.ParCoolConfig;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.ForgeConfigSpec;

public class SettingEnumConfigScreen
extends ParCoolSettingScreen {
    private final EnumConfigSet<?>[] enumConfigList = new EnumConfigSet[]{new EnumConfigSet<Position.Horizontal>(ParCoolConfig.Client.AlignHorizontalStaminaHUD), new EnumConfigSet<Position.Vertical>(ParCoolConfig.Client.AlignVerticalStaminaHUD), new EnumConfigSet<FastRun.ControlType>(ParCoolConfig.Client.FastRunControl), new EnumConfigSet<Crawl.ControlType>(ParCoolConfig.Client.CrawlControl), new EnumConfigSet<Flipping.ControlType>(ParCoolConfig.Client.FlipControl), new EnumConfigSet<HorizontalWallRun.ControlType>(ParCoolConfig.Client.HWallRunControl), new EnumConfigSet<Vault.TypeSelectionMode>(ParCoolConfig.Client.VaultAnimationMode), new EnumConfigSet<ColorTheme>(ParCoolConfig.Client.GUIColorTheme), new EnumConfigSet<HUDType>(ParCoolConfig.Client.StaminaHUDType)};
    private final Button[] enumConfigButtons = new Button[this.enumConfigList.length];

    public SettingEnumConfigScreen(ITextComponent titleIn, ActionInfo info, ColorTheme theme) {
        super(titleIn, info, theme);
        this.currentScreen = 2;
        int i = 0;
        while (i < this.enumConfigList.length) {
            int index = i++;
            this.enumConfigButtons[index] = new Button(0, 0, 0, 0, (ITextComponent)new StringTextComponent(((Enum)this.enumConfigList[index].get()).toString()), it -> {
                this.enumConfigList[index].next();
                it.func_238482_a_((ITextComponent)new StringTextComponent(((Enum)this.enumConfigList[index].get()).toString()));
            });
        }
    }

    @Override
    protected boolean isDownScrollable() {
        return this.topIndex + this.viewableItemCount < this.enumConfigButtons.length;
    }

    @Override
    protected void renderContents(MatrixStack matrixStack, int mouseX, int mouseY, float partialTick, int topOffset, int bottomOffset) {
        int offsetX = 40;
        int contentWidth = this.field_230708_k_ - 80;
        int contentHeight = this.field_230709_l_ - topOffset - bottomOffset;
        this.viewableItemCount = contentHeight / 21;
        for (Button configButton : this.enumConfigButtons) {
            configButton.func_230991_b_(0);
        }
        for (int i = 0; i < this.viewableItemCount && i + this.topIndex < this.enumConfigList.length; ++i) {
            Button button = this.enumConfigButtons[i + this.topIndex];
            int buttonWidth = contentWidth / 3;
            button.field_230690_l_ = this.field_230708_k_ - 40 - buttonWidth;
            button.field_230691_m_ = topOffset + 21 * i;
            button.func_230991_b_(buttonWidth);
            button.setHeight(20);
            button.func_230430_a_(matrixStack, mouseX, mouseY, partialTick);
            List path = this.enumConfigList[i + this.topIndex].configInstance.getPath();
            String string = (String)path.get(path.size() - 1);
            int n = button.field_230691_m_ + 1;
            int n2 = button.func_238483_d_();
            this.field_230712_o_.getClass();
            SettingEnumConfigScreen.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)string, (int)46, (int)(n + (n2 - 9) / 2), (int)this.color.getText());
            SettingEnumConfigScreen.func_238467_a_((MatrixStack)matrixStack, (int)40, (int)(button.field_230691_m_ + button.func_238483_d_()), (int)(this.field_230708_k_ - 40), (int)(button.field_230691_m_ + button.func_238483_d_() + 1), (int)this.color.getSubSeparator());
        }
        SettingEnumConfigScreen.func_238467_a_((MatrixStack)matrixStack, (int)(this.field_230708_k_ - 40), (int)topOffset, (int)(this.field_230708_k_ - 40 - 1), (int)(topOffset + contentHeight), (int)this.color.getSeparator());
        SettingEnumConfigScreen.func_238467_a_((MatrixStack)matrixStack, (int)40, (int)topOffset, (int)41, (int)(topOffset + contentHeight), (int)this.color.getSeparator());
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int type) {
        for (Button button : this.enumConfigButtons) {
            if (!button.func_231044_a_(mouseX, mouseY, type)) continue;
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, type);
    }

    @Override
    public void func_231175_as__() {
        super.func_231175_as__();
    }

    @Override
    protected void save() {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        Parkourability parkourability = Parkourability.get((PlayerEntity)player);
        if (parkourability == null) {
            return;
        }
        parkourability.getActionInfo().setClientSetting(ClientSetting.readFromLocalConfig());
        SyncClientInformationMessage.sync(player, true);
    }

    private static class EnumConfigSet<T extends Enum<T>> {
        final ForgeConfigSpec.EnumValue<T> configInstance;
        final T[] values;

        public EnumConfigSet(ForgeConfigSpec.EnumValue<T> configInstance) {
            this.configInstance = configInstance;
            this.values = (Enum[])((Enum)configInstance.get()).getDeclaringClass().getEnumConstants();
        }

        public void next() {
            int index = (((Enum)this.configInstance.get()).ordinal() + 1) % this.values.length;
            this.configInstance.set(this.values[index]);
        }

        public T get() {
            return (T)((Enum)this.configInstance.get());
        }
    }
}

