/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.client.hud.impl;

import com.alrex.parcool.api.Effects;
import com.alrex.parcool.client.hud.impl.StaminaHUD;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.config.ParCoolConfig;
import com.alrex.parcool.utilities.MathUtil;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.event.TickEvent;

public class LightStaminaHUD
extends AbstractGui {
    private long lastStaminaChangedTick = 0L;
    private int lastChangingSign = 0;
    private int changingSign = 0;
    private long changingTimeTick = 0L;
    private int randomOffset = 0;
    private boolean justBecameMax = false;
    private float statusValue = 0.0f;
    private float oldStatusValue = 0.0f;
    private boolean showStatus = false;

    public void onTick(TickEvent.ClientTickEvent event, ClientPlayerEntity player) {
        IStamina stamina = IStamina.get((PlayerEntity)player);
        Parkourability parkourability = Parkourability.get((PlayerEntity)player);
        if (stamina == null || parkourability == null) {
            return;
        }
        this.changingSign = (int)Math.signum(stamina.get() - stamina.getOldValue());
        long gameTime = player.field_70170_p.func_82737_E();
        if (this.changingSign != this.lastChangingSign) {
            this.lastChangingSign = this.changingSign;
            this.changingTimeTick = 0L;
        } else {
            ++this.changingTimeTick;
        }
        this.randomOffset = player.func_70681_au().nextInt(5) == 0 ? (this.randomOffset += player.func_70681_au().nextBoolean() ? 1 : -1) : 0;
        if (stamina.get() != stamina.getOldValue() || stamina.isExhausted()) {
            this.lastStaminaChangedTick = gameTime;
        }
        this.justBecameMax = stamina.getOldValue() < stamina.get() && stamina.get() == stamina.getActualMaxStamina();
        this.oldStatusValue = this.statusValue;
        boolean oldShowStatus = this.showStatus;
        this.showStatus = false;
        for (Action a : parkourability.getList()) {
            if (!a.wantsToShowStatusBar(player, parkourability)) continue;
            this.showStatus = true;
            this.statusValue = a.getStatusValue(player, parkourability);
            if (this.statusValue > 1.0f) {
                this.statusValue = 1.0f;
                break;
            }
            if (!(this.statusValue < 0.0f)) break;
            this.statusValue = 0.0f;
            break;
        }
        if (!oldShowStatus && this.showStatus) {
            this.oldStatusValue = this.statusValue;
        }
    }

    public void render(RenderGameOverlayEvent.Post event, MatrixStack stack) {
        long gameTime;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null || player.func_184812_l_()) {
            return;
        }
        IStamina stamina = IStamina.get((PlayerEntity)player);
        Parkourability parkourability = Parkourability.get((PlayerEntity)player);
        if (stamina == null || parkourability == null) {
            return;
        }
        boolean inexhaustible = player.func_70644_a((Effect)Effects.INEXHAUSTIBLE.get());
        boolean exhausted = stamina.isExhausted();
        if (!this.showStatus && (gameTime = player.field_70170_p.func_82737_E()) - this.lastStaminaChangedTick > 40L) {
            return;
        }
        float staminaScale = (float)stamina.get() / (float)stamina.getActualMaxStamina();
        if (staminaScale < 0.0f) {
            staminaScale = 0.0f;
        }
        if (staminaScale > 1.0f) {
            staminaScale = 1.0f;
        }
        staminaScale *= 10.0f;
        float statusScale = this.showStatus ? MathUtil.lerp(this.oldStatusValue, this.statusValue, event.getPartialTicks()) * 10.0f : 0.0f;
        Minecraft mc = Minecraft.func_71410_x();
        int scaledWidth = event.getWindow().func_198107_o();
        int scaledHeight = event.getWindow().func_198087_p();
        mc.func_110434_K().func_110577_a(StaminaHUD.STAMINA);
        int baseX = scaledWidth / 2 + 91 + ParCoolConfig.Client.Integers.HorizontalOffsetOfLightStaminaHUD.get();
        int baseY = scaledHeight - ForgeIngameGui.right_height + ParCoolConfig.Client.Integers.VerticalOffsetOfLightStaminaHUD.get();
        for (int i = 0; i < 10; ++i) {
            int x = baseX - i * 8 - 9;
            int offsetY = 0;
            int textureX = inexhaustible ? (this.showStatus ? (statusScale > (float)i + 0.9f ? 90 : 0) : 54) : (exhausted ? 27 : (statusScale > (float)i + 0.9f ? 90 : 0));
            if (this.justBecameMax) {
                textureX = 81;
            } else if (staminaScale < (float)i) {
                textureX += 18;
            } else if (staminaScale < (float)i + 0.5f) {
                textureX += 9;
            }
            if (this.justBecameMax) {
                offsetY = -1;
            } else if (this.changingSign == 1) {
                if ((this.changingTimeTick & 0x1FL) == (long)i) {
                    offsetY = -1;
                }
            } else if ((float)(i + 1) > staminaScale && staminaScale > (float)i && this.changingSign == -1) {
                offsetY = this.randomOffset;
            }
            LightStaminaHUD.func_238463_a_((MatrixStack)stack, (int)x, (int)(baseY + offsetY), (float)textureX, (float)119.0f, (int)9, (int)9, (int)129, (int)128);
        }
        ForgeIngameGui.right_height += 10;
    }
}

