/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.action;

import com.alrex.parcool.api.unstable.action.ParCoolActionEvent;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.StaminaConsumeTiming;
import com.alrex.parcool.common.capability.Animation;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.common.network.SyncActionStateMessage;
import com.alrex.parcool.common.network.SyncStaminaMessage;
import java.nio.ByteBuffer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;

public class ActionProcessor {
    private final ByteBuffer bufferOfPostState = ByteBuffer.allocate(128);
    private final ByteBuffer bufferOfPreState = ByteBuffer.allocate(128);
    private final ByteBuffer bufferOfStarting = ByteBuffer.allocate(128);
    private int staminaSyncCoolTimeTick = 0;

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onTickInClient(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        if (event.side != LogicalSide.CLIENT) {
            return;
        }
        AbstractClientPlayerEntity player = (AbstractClientPlayerEntity)event.player;
        Animation animation = Animation.get((PlayerEntity)player);
        if (animation == null) {
            return;
        }
        Parkourability parkourability = Parkourability.get((PlayerEntity)player);
        if (parkourability == null) {
            return;
        }
        animation.tick(player, parkourability);
    }

    @SubscribeEvent
    public void onTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        PlayerEntity player = event.player;
        Parkourability parkourability = Parkourability.get(player);
        IStamina stamina = IStamina.get(player);
        if (parkourability == null || stamina == null) {
            return;
        }
        List<Action> actions = parkourability.getList();
        boolean needSync = event.side == LogicalSide.CLIENT && player.func_175144_cb();
        SyncActionStateMessage.Encoder builder = SyncActionStateMessage.Encoder.reset();
        stamina.tick();
        parkourability.getAdditionalProperties().onTick(player, parkourability);
        block0: for (Action action : actions) {
            StaminaConsumeTiming timing = action.getStaminaConsumeTiming();
            if (needSync) {
                this.bufferOfPreState.clear();
                action.saveSynchronizedState(this.bufferOfPreState);
                this.bufferOfPreState.flip();
            }
            if (action.isDoing()) {
                action.setDoingTick(action.getDoingTick() + 1);
                action.setNotDoingTick(0);
            } else {
                action.setDoingTick(0);
                action.setNotDoingTick(action.getNotDoingTick() + 1);
            }
            action.onTick(player, parkourability, stamina);
            if (event.side == LogicalSide.CLIENT) {
                action.onClientTick(player, parkourability, stamina);
            } else {
                action.onServerTick(player, parkourability, stamina);
            }
            if (player.func_175144_cb()) {
                if (action.isDoing()) {
                    boolean canContinue = action.canContinue(player, parkourability, stamina);
                    if (!canContinue) {
                        action.setDoing(false);
                        action.onStopInLocalClient(player);
                        action.onStop(player);
                        MinecraftForge.EVENT_BUS.post((Event)new ParCoolActionEvent.StopEvent(player, action));
                        builder.appendFinishMsg(parkourability, action);
                    }
                } else {
                    this.bufferOfStarting.clear();
                    boolean start = parkourability.getActionInfo().can(action.getClass()) && !MinecraftForge.EVENT_BUS.post((Event)new ParCoolActionEvent.TryToStartEvent(player, action)) && action.canStart(player, parkourability, stamina, this.bufferOfStarting);
                    this.bufferOfStarting.flip();
                    if (start) {
                        action.setDoing(true);
                        action.onStartInLocalClient(player, parkourability, stamina, this.bufferOfStarting);
                        this.bufferOfStarting.rewind();
                        action.onStart(player, parkourability);
                        MinecraftForge.EVENT_BUS.post((Event)new ParCoolActionEvent.StartEvent(player, action));
                        builder.appendStartData(parkourability, action, this.bufferOfStarting);
                        if (timing == StaminaConsumeTiming.OnStart) {
                            stamina.consume(parkourability.getActionInfo().getStaminaConsumptionOf(action.getClass()));
                        }
                    }
                }
            }
            if (action.isDoing()) {
                action.onWorkingTick(player, parkourability, stamina);
                if (event.side == LogicalSide.CLIENT) {
                    action.onWorkingTickInClient(player, parkourability, stamina);
                    if (player.func_175144_cb()) {
                        action.onWorkingTickInLocalClient(player, parkourability, stamina);
                        if (timing == StaminaConsumeTiming.OnWorking) {
                            stamina.consume(parkourability.getActionInfo().getStaminaConsumptionOf(action.getClass()));
                        }
                    }
                } else {
                    action.onWorkingTickInServer(player, parkourability, stamina);
                }
            }
            if (!needSync) continue;
            this.bufferOfPostState.clear();
            action.saveSynchronizedState(this.bufferOfPostState);
            this.bufferOfPostState.flip();
            if (this.bufferOfPostState.limit() == this.bufferOfPreState.limit()) {
                while (this.bufferOfPreState.hasRemaining()) {
                    if (this.bufferOfPostState.get() == this.bufferOfPreState.get()) continue;
                    this.bufferOfPostState.rewind();
                    builder.appendSyncData(parkourability, action, this.bufferOfPostState);
                    continue block0;
                }
                continue;
            }
            this.bufferOfPostState.rewind();
            builder.appendSyncData(parkourability, action, this.bufferOfPostState);
        }
        if (needSync) {
            SyncActionStateMessage.sync(player, builder);
            ++this.staminaSyncCoolTimeTick;
            if (this.staminaSyncCoolTimeTick > 5 || stamina.wantToConsumeOnServer()) {
                this.staminaSyncCoolTimeTick = 0;
                SyncStaminaMessage.sync(player);
            }
            if (stamina.isExhausted()) {
                player.func_70031_b(false);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        ClientPlayerEntity clientPlayer = Minecraft.func_71410_x().field_71439_g;
        if (clientPlayer == null) {
            return;
        }
        for (PlayerEntity player : clientPlayer.field_70170_p.func_217369_A()) {
            Parkourability parkourability = Parkourability.get(player);
            if (parkourability == null) {
                return;
            }
            List<Action> actions = parkourability.getList();
            for (Action action : actions) {
                action.onRenderTick(event, player, parkourability);
            }
            Animation animation = Animation.get(player);
            if (animation == null) {
                return;
            }
            animation.onRenderTick(event, player, parkourability);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onViewRender(EntityViewRenderEvent.CameraSetup event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        Parkourability parkourability = Parkourability.get((PlayerEntity)player);
        if (parkourability == null) {
            return;
        }
        Animation animation = Animation.get((PlayerEntity)player);
        if (animation == null) {
            return;
        }
        animation.cameraSetup(event, player, parkourability);
    }
}

