/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.action.impl;

import com.alrex.parcool.api.SoundEvents;
import com.alrex.parcool.client.animation.impl.CatLeapAnimator;
import com.alrex.parcool.client.input.KeyRecorder;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.StaminaConsumeTiming;
import com.alrex.parcool.common.action.impl.ChargeJump;
import com.alrex.parcool.common.action.impl.FastRun;
import com.alrex.parcool.common.action.impl.Roll;
import com.alrex.parcool.common.action.impl.Tap;
import com.alrex.parcool.common.capability.Animation;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.config.ParCoolConfig;
import java.nio.ByteBuffer;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CatLeap
extends Action {
    private int coolTimeTick = 0;
    private boolean ready = false;
    private int readyTick = 0;
    private static final int MAX_COOL_TIME_TICK = 30;

    @Override
    public void onTick(PlayerEntity player, Parkourability parkourability, IStamina stamina) {
        if (this.coolTimeTick > 0) {
            --this.coolTimeTick;
        }
    }

    @Override
    public void onClientTick(PlayerEntity player, Parkourability parkourability, IStamina stamina) {
        if (player.func_175144_cb()) {
            if (KeyRecorder.keySneak.isPressed() && parkourability.get(FastRun.class).getNotDashTick(parkourability.getAdditionalProperties()) < 10) {
                this.ready = true;
            }
            if (this.ready) {
                ++this.readyTick;
            }
            if (this.readyTick > 10) {
                this.ready = false;
                this.readyTick = 0;
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canStart(PlayerEntity player, Parkourability parkourability, IStamina stamina, ByteBuffer startInfo) {
        Vector3d movement = player.func_213322_ci();
        if (movement.func_189985_c() < 0.001) {
            return false;
        }
        movement = movement.func_216372_d(1.0, 0.0, 1.0).func_72432_b();
        startInfo.putDouble(movement.func_82615_a()).putDouble(movement.func_82616_c());
        return player.func_233570_aj_() && !stamina.isExhausted() && this.coolTimeTick <= 0 && this.readyTick > 0 && parkourability.get(ChargeJump.class).getChargingTick() < 5 && !parkourability.get(Roll.class).isDoing() && !parkourability.get(Tap.class).isDoing() && KeyRecorder.keySneak.isReleased();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canContinue(PlayerEntity player, Parkourability parkourability, IStamina stamina) {
        return (this.getDoingTick() <= 1 || !player.func_233570_aj_()) && !player.func_184613_cA() && !player.func_203005_aq() && !player.func_180799_ab();
    }

    @Override
    public void onStartInLocalClient(PlayerEntity player, Parkourability parkourability, IStamina stamina, ByteBuffer startData) {
        Vector3d jumpDirection = new Vector3d(startData.getDouble(), 0.0, startData.getDouble());
        if (ParCoolConfig.Client.Booleans.EnableActionSounds.get().booleanValue()) {
            player.func_184185_a((SoundEvent)SoundEvents.CATLEAP.get(), 1.0f, 1.0f);
        }
        this.coolTimeTick = 30;
        this.spawnJumpEffect(player, jumpDirection);
        player.func_70664_aZ();
        Vector3d motionVec = player.func_213322_ci();
        player.func_213293_j(jumpDirection.func_82615_a(), motionVec.func_82617_b() * 1.16667, jumpDirection.func_82616_c());
        Animation animation = Animation.get(player);
        if (animation != null) {
            animation.setAnimator(new CatLeapAnimator());
        }
    }

    @Override
    public void onStartInOtherClient(PlayerEntity player, Parkourability parkourability, ByteBuffer startData) {
        Vector3d jumpDirection = new Vector3d(startData.getDouble(), 0.0, startData.getDouble());
        if (ParCoolConfig.Client.Booleans.EnableActionSounds.get().booleanValue()) {
            player.func_184185_a((SoundEvent)SoundEvents.CATLEAP.get(), 1.0f, 1.0f);
        }
        this.spawnJumpEffect(player, jumpDirection);
        Animation animation = Animation.get(player);
        if (animation != null) {
            animation.setAnimator(new CatLeapAnimator());
        }
    }

    @Override
    public StaminaConsumeTiming getStaminaConsumeTiming() {
        return StaminaConsumeTiming.OnStart;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnJumpEffect(PlayerEntity player, Vector3d jumpDirection) {
        World level = player.field_70170_p;
        Vector3d pos = player.func_213303_ch();
        BlockPos blockpos = new BlockPos(pos.func_72441_c(0.0, -0.2, 0.0));
        if (!level.func_195588_v(blockpos)) {
            return;
        }
        float width = player.func_213311_cf();
        BlockState blockstate = level.func_180495_p(blockpos);
        if (blockstate.func_185901_i() != BlockRenderType.INVISIBLE) {
            for (int i = 0; i < 20; ++i) {
                Vector3d particlePos = new Vector3d(pos.func_82615_a() + (jumpDirection.func_82615_a() * -0.5 + player.func_70681_au().nextDouble() - 0.5) * (double)width, pos.func_82617_b() + 0.1, pos.func_82616_c() + (jumpDirection.func_82616_c() * -0.5 + player.func_70681_au().nextDouble() - 0.5) * (double)width);
                Vector3d particleSpeed = particlePos.func_178788_d(pos).func_72432_b().func_186678_a(2.5 + 8.0 * player.func_70681_au().nextDouble()).func_72441_c(0.0, 1.5, 0.0);
                level.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, blockstate).setPos(blockpos), particlePos.func_82615_a(), particlePos.func_82617_b(), particlePos.func_82616_c(), particleSpeed.func_82615_a(), particleSpeed.func_82617_b(), particleSpeed.func_82616_c());
            }
        }
    }
}

