/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.action.impl;

import com.alrex.parcool.api.SoundEvents;
import com.alrex.parcool.client.animation.impl.ChargeJumpAnimator;
import com.alrex.parcool.client.animation.impl.JumpChargingAnimator;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.StaminaConsumeTiming;
import com.alrex.parcool.common.action.impl.Crawl;
import com.alrex.parcool.common.capability.Animation;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.config.ParCoolConfig;
import com.alrex.parcool.utilities.VectorUtil;
import java.nio.ByteBuffer;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;

public class ChargeJump
extends Action {
    public static final int JUMP_ANIMATION_TICK = 10;
    public static final int JUMP_CHARGE_TICK = 11;
    private int chargeTick = 0;
    private int lastChargeTick = 0;
    private int notChargeTick = 0;
    private boolean started = false;

    @Override
    public boolean canStart(PlayerEntity player, Parkourability parkourability, IStamina stamina, ByteBuffer startInfo) {
        boolean start = this.started;
        this.started = false;
        return start;
    }

    @Override
    public boolean canContinue(PlayerEntity player, Parkourability parkourability, IStamina stamina) {
        return this.getDoingTick() < 10;
    }

    @Override
    public StaminaConsumeTiming getStaminaConsumeTiming() {
        return StaminaConsumeTiming.OnStart;
    }

    @Override
    public void onStartInLocalClient(PlayerEntity player, Parkourability parkourability, IStamina stamina, ByteBuffer startData) {
        Animation animation;
        if (ParCoolConfig.Client.Booleans.EnableActionSounds.get().booleanValue()) {
            player.func_184185_a((SoundEvent)SoundEvents.CHARGE_JUMP.get(), 1.0f, 1.0f);
        }
        if ((animation = Animation.get(player)) != null) {
            animation.setAnimator(new ChargeJumpAnimator());
        }
    }

    @Override
    public void onStartInOtherClient(PlayerEntity player, Parkourability parkourability, ByteBuffer startData) {
        Animation animation;
        if (ParCoolConfig.Client.Booleans.EnableActionSounds.get().booleanValue()) {
            player.func_184185_a((SoundEvent)SoundEvents.CHARGE_JUMP.get(), 1.0f, 1.0f);
        }
        if ((animation = Animation.get(player)) != null) {
            animation.setAnimator(new ChargeJumpAnimator());
        }
    }

    @Override
    public void onClientTick(PlayerEntity player, Parkourability parkourability, IStamina stamina) {
        Animation animation;
        if (player instanceof ClientPlayerEntity) {
            ClientPlayerEntity cp = (ClientPlayerEntity)player;
            if (!(!cp.func_233570_aj_() || stamina.isExhausted() || !parkourability.getActionInfo().can(ChargeJump.class) || cp.func_213300_bk() || cp.func_70051_ag() || cp.func_203005_aq() || cp.field_71158_b.field_187255_c || cp.field_71158_b.field_187256_d || cp.field_71158_b.field_187258_f || cp.field_71158_b.field_187257_e || parkourability.get(Crawl.class).isDoing())) {
                if (cp.func_225608_bj_()) {
                    ++this.chargeTick;
                    if (this.chargeTick > 11) {
                        this.chargeTick = 11;
                    }
                    this.lastChargeTick = this.chargeTick;
                    this.notChargeTick = 0;
                } else {
                    --this.chargeTick;
                    if (this.chargeTick < 0) {
                        this.chargeTick = 0;
                    }
                    ++this.notChargeTick;
                }
                if (this.isCharging()) {
                    Vector3d targetAngle = VectorUtil.fromYawDegree(player.field_70759_as);
                    Vector3d currentAngle = VectorUtil.fromYawDegree(player.field_70761_aq);
                    double differenceAngle = Math.atan((currentAngle.func_82615_a() * targetAngle.func_82616_c() - targetAngle.func_82615_a() * currentAngle.func_82616_c()) / (targetAngle.func_82615_a() * currentAngle.func_82615_a() + targetAngle.func_82616_c() * currentAngle.func_82616_c()));
                    player.func_181013_g((float)VectorUtil.toYawDegree(currentAngle.func_178785_b((float)(-differenceAngle / 2.0))));
                }
            } else {
                this.chargeTick = 0;
                ++this.notChargeTick;
            }
        }
        if (this.isCharging() && (animation = Animation.get(player)) != null && !animation.hasAnimator()) {
            animation.setAnimator(new JumpChargingAnimator());
        }
    }

    public void onJump(PlayerEntity player, Parkourability parkourability, IStamina stamina) {
        if (this.chargeTick >= 11 || this.lastChargeTick > 11 && this.notChargeTick < 5) {
            player.func_213317_d(player.func_213322_ci().func_72441_c(0.0, 0.11, 0.0));
            this.started = true;
        }
    }

    public void onLand(PlayerEntity player, Parkourability parkourability) {
        if (player.func_175144_cb() && player instanceof ClientPlayerEntity) {
            ClientPlayerEntity cp = (ClientPlayerEntity)player;
            if (!(!parkourability.getActionInfo().can(ChargeJump.class) || cp.field_71158_b.field_187255_c || cp.field_71158_b.field_187256_d || cp.field_71158_b.field_187258_f || cp.field_71158_b.field_187257_e)) {
                this.lastChargeTick = this.chargeTick = 16;
                this.notChargeTick = 0;
            }
        }
    }

    @Override
    public boolean wantsToShowStatusBar(ClientPlayerEntity player, Parkourability parkourability) {
        return this.isCharging();
    }

    @Override
    public float getStatusValue(ClientPlayerEntity player, Parkourability parkourability) {
        return (float)this.getChargingTick() / 11.0f;
    }

    @Override
    public void saveSynchronizedState(ByteBuffer buffer) {
        buffer.putInt(this.chargeTick);
    }

    @Override
    public void restoreSynchronizedState(ByteBuffer buffer) {
        this.chargeTick = buffer.getInt();
    }

    public boolean isCharging() {
        return this.chargeTick > 0 && !this.isDoing();
    }

    public int getChargingTick() {
        return this.chargeTick;
    }
}

