/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.action.impl;

import com.alrex.parcool.api.SoundEvents;
import com.alrex.parcool.client.animation.impl.ClingToCliffAnimator;
import com.alrex.parcool.client.input.KeyBindings;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.StaminaConsumeTiming;
import com.alrex.parcool.common.action.impl.ClimbUp;
import com.alrex.parcool.common.action.impl.HorizontalWallRun;
import com.alrex.parcool.common.capability.Animation;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.config.ParCoolConfig;
import com.alrex.parcool.utilities.VectorUtil;
import com.alrex.parcool.utilities.WorldUtil;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;

public class ClingToCliff
extends Action {
    private float armSwingAmount = 0.0f;
    private FacingDirection facingDirection = FacingDirection.ToWall;
    @Nullable
    private Vector3d clingWallDirection = null;

    public float getArmSwingAmount() {
        return this.armSwingAmount;
    }

    @Override
    public void onWorkingTick(PlayerEntity player, Parkourability parkourability, IStamina stamina) {
        player.field_70143_R = 0.0f;
    }

    public FacingDirection getFacingDirection() {
        return this.facingDirection;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canStart(PlayerEntity player, Parkourability parkourability, IStamina stamina, ByteBuffer startInfo) {
        boolean value;
        boolean bl = value = !stamina.isExhausted() && player.func_213322_ci().func_82617_b() < 0.2 && !player.func_225608_bj_() && !parkourability.get(HorizontalWallRun.class).isDoing() && KeyBindings.getKeyGrabWall().func_151470_d();
        if (!value) {
            return false;
        }
        Vector3d wallVec = WorldUtil.getGrabbableWall((LivingEntity)player);
        if (wallVec == null) {
            return false;
        }
        startInfo.putDouble(wallVec.func_82615_a()).putDouble(wallVec.func_82616_c());
        return 0.5 < wallVec.func_72432_b().func_72430_b(player.func_70040_Z().func_216372_d(1.0, 0.0, 1.0).func_72432_b());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canContinue(PlayerEntity player, Parkourability parkourability, IStamina stamina) {
        return !stamina.isExhausted() && !player.func_225608_bj_() && parkourability.getActionInfo().can(ClingToCliff.class) && KeyBindings.getKeyGrabWall().func_151470_d() && !parkourability.get(HorizontalWallRun.class).isDoing() && !parkourability.get(ClimbUp.class).isDoing() && WorldUtil.getGrabbableWall((LivingEntity)player) != null;
    }

    @Override
    public void onStart(PlayerEntity player, Parkourability parkourability) {
        this.armSwingAmount = 0.0f;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onStartInLocalClient(PlayerEntity player, Parkourability parkourability, IStamina stamina, ByteBuffer startData) {
        Animation animation;
        this.clingWallDirection = new Vector3d(startData.getDouble(), 0.0, startData.getDouble());
        this.facingDirection = FacingDirection.ToWall;
        this.armSwingAmount = 0.0f;
        if (ParCoolConfig.Client.Booleans.EnableActionSounds.get().booleanValue()) {
            player.func_184185_a((SoundEvent)SoundEvents.CLING_TO_CLIFF.get(), 1.0f, 1.0f);
        }
        if ((animation = Animation.get(player)) != null) {
            animation.setAnimator(new ClingToCliffAnimator());
        }
    }

    @Override
    public void onStartInOtherClient(PlayerEntity player, Parkourability parkourability, ByteBuffer startData) {
        Animation animation;
        this.clingWallDirection = new Vector3d(startData.getDouble(), 0.0, startData.getDouble());
        this.facingDirection = FacingDirection.ToWall;
        this.armSwingAmount = 0.0f;
        if (ParCoolConfig.Client.Booleans.EnableActionSounds.get().booleanValue()) {
            player.func_184185_a((SoundEvent)SoundEvents.CLING_TO_CLIFF.get(), 1.0f, 1.0f);
        }
        if ((animation = Animation.get(player)) != null) {
            animation.setAnimator(new ClingToCliffAnimator());
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onWorkingTickInLocalClient(PlayerEntity player, Parkourability parkourability, IStamina stamina) {
        this.armSwingAmount += (float)player.func_213322_ci().func_216372_d(1.0, 0.0, 1.0).func_189985_c();
        if (KeyBindings.getKeyLeft().func_151470_d() && KeyBindings.getKeyRight().func_151470_d()) {
            player.func_213293_j(0.0, 0.0, 0.0);
        } else if (this.clingWallDirection != null && this.facingDirection == FacingDirection.ToWall) {
            Vector3d vec = this.clingWallDirection.func_178785_b(1.5707964f).func_72432_b().func_186678_a(0.1);
            if (KeyBindings.getKeyLeft().func_151470_d()) {
                player.func_213317_d(vec);
            } else if (KeyBindings.getKeyRight().func_151470_d()) {
                player.func_213317_d(vec.func_216371_e());
            } else {
                player.func_213293_j(0.0, 0.0, 0.0);
            }
        } else {
            player.func_213293_j(0.0, 0.0, 0.0);
        }
    }

    @Override
    public void onWorkingTickInClient(PlayerEntity player, Parkourability parkourability, IStamina stamina) {
        this.clingWallDirection = WorldUtil.getGrabbableWall((LivingEntity)player);
        if (this.clingWallDirection == null) {
            return;
        }
        this.clingWallDirection = this.clingWallDirection.func_72432_b();
        Vector3d lookingAngle = player.func_70040_Z().func_216372_d(1.0, 0.0, 1.0).func_72432_b();
        Vector3d angle = new Vector3d(this.clingWallDirection.func_82615_a() * lookingAngle.func_82615_a() + this.clingWallDirection.func_82616_c() * lookingAngle.func_82616_c(), 0.0, -this.clingWallDirection.func_82615_a() * lookingAngle.func_82616_c() + this.clingWallDirection.func_82616_c() * lookingAngle.func_82615_a()).func_72432_b();
        this.facingDirection = angle.func_82615_a() > 0.342 ? FacingDirection.ToWall : (angle.func_82616_c() < 0.0 ? FacingDirection.RightAgainstWall : FacingDirection.LeftAgainstWall);
    }

    @Override
    public void saveSynchronizedState(ByteBuffer buffer) {
        buffer.putFloat(this.armSwingAmount);
    }

    @Override
    public void restoreSynchronizedState(ByteBuffer buffer) {
        this.armSwingAmount = buffer.getFloat();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onRenderTick(TickEvent.RenderTickEvent event, PlayerEntity player, Parkourability parkourability) {
        if (this.isDoing() && this.clingWallDirection != null) {
            switch (this.facingDirection) {
                case ToWall: {
                    player.func_181013_g((float)VectorUtil.toYawDegree(this.clingWallDirection));
                    break;
                }
                case RightAgainstWall: {
                    player.field_70760_ar = player.field_70761_aq = (float)VectorUtil.toYawDegree(this.clingWallDirection.func_178785_b(-1.5707964f));
                    break;
                }
                case LeftAgainstWall: {
                    player.field_70760_ar = player.field_70761_aq = (float)VectorUtil.toYawDegree(this.clingWallDirection.func_178785_b(1.5707964f));
                }
            }
        }
    }

    @Override
    public StaminaConsumeTiming getStaminaConsumeTiming() {
        return StaminaConsumeTiming.OnWorking;
    }

    public static enum FacingDirection {
        ToWall,
        RightAgainstWall,
        LeftAgainstWall;

    }
}

