/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.action.impl;

import com.alrex.parcool.client.animation.impl.FastRunningAnimator;
import com.alrex.parcool.client.input.KeyBindings;
import com.alrex.parcool.client.input.KeyRecorder;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.AdditionalProperties;
import com.alrex.parcool.common.action.StaminaConsumeTiming;
import com.alrex.parcool.common.action.impl.ClingToCliff;
import com.alrex.parcool.common.action.impl.Crawl;
import com.alrex.parcool.common.action.impl.HangDown;
import com.alrex.parcool.common.capability.Animation;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.common.info.ActionInfo;
import com.alrex.parcool.config.ParCoolConfig;
import java.nio.ByteBuffer;
import java.util.UUID;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FastRun
extends Action {
    private static final String FAST_RUNNING_MODIFIER_NAME = "parcool.modifier.fastrunnning";
    private static final UUID FAST_RUNNING_MODIFIER_UUID = UUID.randomUUID();
    private double speedModifier = 0.0;
    private boolean toggleStatus = false;
    private int lastDashTick = 0;

    public double getSpeedModifier(ActionInfo info) {
        return Math.min(info.getClientSetting().get(ParCoolConfig.Client.Doubles.FastRunSpeedModifier), info.getServerLimitation().get(ParCoolConfig.Server.Doubles.MaxFastRunSpeedModifier));
    }

    @Override
    public void onServerTick(PlayerEntity player, Parkourability parkourability, IStamina stamina) {
        ModifiableAttributeInstance attr = player.func_110148_a(Attributes.field_233821_d_);
        if (attr == null) {
            return;
        }
        if (attr.func_111127_a(FAST_RUNNING_MODIFIER_UUID) != null) {
            attr.func_188479_b(FAST_RUNNING_MODIFIER_UUID);
        }
        if (this.isDoing()) {
            player.func_70031_b(true);
            attr.func_233767_b_(new AttributeModifier(FAST_RUNNING_MODIFIER_UUID, FAST_RUNNING_MODIFIER_NAME, this.speedModifier / 100.0, AttributeModifier.Operation.ADDITION));
        }
    }

    @Override
    public void onClientTick(PlayerEntity player, Parkourability parkourability, IStamina stamina) {
        if (player.func_175144_cb()) {
            if (ParCoolConfig.Client.FastRunControl.get() == ControlType.Toggle && parkourability.getAdditionalProperties().getSprintingTick() > 3) {
                if (KeyRecorder.keyFastRunning.isPressed()) {
                    this.toggleStatus = !this.toggleStatus;
                }
            } else {
                this.toggleStatus = false;
            }
        }
    }

    @Override
    public StaminaConsumeTiming getStaminaConsumeTiming() {
        return StaminaConsumeTiming.OnWorking;
    }

    @Override
    public boolean canStart(PlayerEntity player, Parkourability parkourability, IStamina stamina, ByteBuffer startInfo) {
        return this.canContinue(player, parkourability, stamina);
    }

    @Override
    public boolean canContinue(PlayerEntity player, Parkourability parkourability, IStamina stamina) {
        return !stamina.isExhausted() && !player.func_203005_aq() && player.func_184187_bx() == null && !player.func_184613_cA() && player.func_70051_ag() && !player.func_213300_bk() && !player.func_203007_ba() && !parkourability.get(Crawl.class).isDoing() && !parkourability.get(ClingToCliff.class).isDoing() && !parkourability.get(HangDown.class).isDoing() && (ParCoolConfig.Client.FastRunControl.get() == ControlType.PressKey && KeyBindings.getKeyFastRunning().func_151470_d() || ParCoolConfig.Client.FastRunControl.get() == ControlType.Toggle && this.toggleStatus || ParCoolConfig.Client.FastRunControl.get() == ControlType.Auto);
    }

    @Override
    public void onWorkingTickInClient(PlayerEntity player, Parkourability parkourability, IStamina stamina) {
        Animation animation = Animation.get(player);
        if (animation != null && !animation.hasAnimator()) {
            animation.setAnimator(new FastRunningAnimator());
        }
    }

    @Override
    public void onStartInServer(PlayerEntity player, Parkourability parkourability, ByteBuffer startData) {
        this.speedModifier = this.getSpeedModifier(parkourability.getActionInfo());
    }

    @Override
    public void onStopInLocalClient(PlayerEntity player) {
        Parkourability parkourability = Parkourability.get(player);
        if (parkourability == null) {
            return;
        }
        this.lastDashTick = this.getDashTick(parkourability.getAdditionalProperties());
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean canActWithRunning(PlayerEntity player) {
        return ParCoolConfig.Client.Booleans.SubstituteSprintForFastRun.get() != false ? player.func_70051_ag() : this.isDoing();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getDashTick(AdditionalProperties properties) {
        return ParCoolConfig.Client.Booleans.SubstituteSprintForFastRun.get() != false ? properties.getSprintingTick() : this.getDoingTick();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getNotDashTick(AdditionalProperties properties) {
        return ParCoolConfig.Client.Booleans.SubstituteSprintForFastRun.get() != false ? properties.getNotSprintingTick() : this.getNotDoingTick();
    }

    public int getLastDashTick() {
        return this.lastDashTick;
    }

    public static enum ControlType {
        PressKey,
        Toggle,
        Auto;

    }
}

