/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.action.impl;

import com.alrex.parcool.client.animation.impl.FastSwimAnimator;
import com.alrex.parcool.client.input.KeyBindings;
import com.alrex.parcool.client.input.KeyRecorder;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.StaminaConsumeTiming;
import com.alrex.parcool.common.action.impl.FastRun;
import com.alrex.parcool.common.capability.Animation;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.common.info.ActionInfo;
import com.alrex.parcool.config.ParCoolConfig;
import java.nio.ByteBuffer;
import java.util.UUID;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.common.ForgeMod;

public class FastSwim
extends Action {
    private static final String FAST_SWIM_MODIFIER_NAME = "parcool.modifier.fastswimming";
    private static final UUID FAST_SWIM_MODIFIER_UUID = UUID.randomUUID();
    private double speedModifier = 0.0;
    private boolean toggleStatus;

    public double getSpeedModifier(ActionInfo info) {
        return Math.min(info.getClientSetting().get(ParCoolConfig.Client.Doubles.FastSwimSpeedModifier), info.getServerLimitation().get(ParCoolConfig.Server.Doubles.MaxFastSwimSpeedModifier));
    }

    @Override
    public boolean canStart(PlayerEntity player, Parkourability parkourability, IStamina stamina, ByteBuffer startInfo) {
        return this.canContinue(player, parkourability, stamina);
    }

    @Override
    public boolean canContinue(PlayerEntity player, Parkourability parkourability, IStamina stamina) {
        return !stamina.isExhausted() && player.func_203005_aq() && player.func_184187_bx() == null && !player.func_184613_cA() && player.func_70051_ag() && player.func_203007_ba() && !parkourability.get(FastRun.class).isDoing() && (ParCoolConfig.Client.FastRunControl.get() == FastRun.ControlType.PressKey && KeyBindings.getKeyFastRunning().func_151470_d() || ParCoolConfig.Client.FastRunControl.get() == FastRun.ControlType.Toggle && this.toggleStatus || ParCoolConfig.Client.FastRunControl.get() == FastRun.ControlType.Auto);
    }

    @Override
    public void onClientTick(PlayerEntity player, Parkourability parkourability, IStamina stamina) {
        if (player.func_175144_cb()) {
            if (ParCoolConfig.Client.FastRunControl.get() == FastRun.ControlType.Toggle && parkourability.getAdditionalProperties().getSprintingTick() > 3 && player.func_203005_aq() && player.func_203007_ba()) {
                if (KeyRecorder.keyFastRunning.isPressed()) {
                    this.toggleStatus = !this.toggleStatus;
                }
            } else {
                this.toggleStatus = false;
            }
        }
    }

    @Override
    public void onWorkingTickInClient(PlayerEntity player, Parkourability parkourability, IStamina stamina) {
        Animation animation = Animation.get(player);
        if (animation != null && !animation.hasAnimator()) {
            animation.setAnimator(new FastSwimAnimator());
        }
    }

    @Override
    public void onStartInServer(PlayerEntity player, Parkourability parkourability, ByteBuffer startData) {
        this.speedModifier = parkourability.get(FastSwim.class).getSpeedModifier(parkourability.getActionInfo());
    }

    @Override
    public void onServerTick(PlayerEntity player, Parkourability parkourability, IStamina stamina) {
        ModifiableAttributeInstance attr = player.func_110148_a((Attribute)ForgeMod.SWIM_SPEED.get());
        if (attr == null) {
            return;
        }
        if (attr.func_111127_a(FAST_SWIM_MODIFIER_UUID) != null) {
            attr.func_188479_b(FAST_SWIM_MODIFIER_UUID);
        }
        if (this.isDoing()) {
            player.func_70031_b(true);
            attr.func_233767_b_(new AttributeModifier(FAST_SWIM_MODIFIER_UUID, FAST_SWIM_MODIFIER_NAME, this.speedModifier / 8.0, AttributeModifier.Operation.ADDITION));
        }
    }

    @Override
    public StaminaConsumeTiming getStaminaConsumeTiming() {
        return StaminaConsumeTiming.OnWorking;
    }
}

