/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.action.impl;

import com.alrex.parcool.api.SoundEvents;
import com.alrex.parcool.client.animation.impl.HangAnimator;
import com.alrex.parcool.client.input.KeyBindings;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.StaminaConsumeTiming;
import com.alrex.parcool.common.action.impl.ClingToCliff;
import com.alrex.parcool.common.action.impl.JumpFromBar;
import com.alrex.parcool.common.capability.Animation;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.config.ParCoolConfig;
import com.alrex.parcool.utilities.VectorUtil;
import com.alrex.parcool.utilities.WorldUtil;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;

public class HangDown
extends Action {
    private double bodySwingAngleFactor = 0.0;
    private float armSwingAmount = 0.0f;
    private boolean orthogonalToBar = false;
    private BarAxis hangingBarAxis = null;

    public float getArmSwingAmount() {
        return this.armSwingAmount;
    }

    public double getBodySwingAngleFactor() {
        return this.bodySwingAngleFactor;
    }

    public boolean isOrthogonalToBar() {
        return this.orthogonalToBar;
    }

    @Nullable
    public BarAxis getHangingBarAxis() {
        return this.hangingBarAxis;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canStart(PlayerEntity player, Parkourability parkourability, IStamina stamina, ByteBuffer startInfo) {
        startInfo.putDouble(Math.max(-1.0, Math.min(1.0, 3.0 * player.func_70040_Z().func_216372_d(1.0, 0.0, 1.0).func_72432_b().func_72430_b(player.func_213322_ci()))));
        return !stamina.isExhausted() && !player.func_225608_bj_() && Math.abs(player.func_213322_ci().func_82617_b()) < 0.2 && KeyBindings.getKeyHangDown().func_151470_d() && !parkourability.get(JumpFromBar.class).isDoing() && !parkourability.get(ClingToCliff.class).isDoing() && WorldUtil.getHangableBars((LivingEntity)player) != null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canContinue(PlayerEntity player, Parkourability parkourability, IStamina stamina) {
        return !stamina.isExhausted() && !player.func_225608_bj_() && KeyBindings.getKeyHangDown().func_151470_d() && parkourability.getActionInfo().can(HangDown.class) && !parkourability.get(JumpFromBar.class).isDoing() && !parkourability.get(ClingToCliff.class).isDoing() && WorldUtil.getHangableBars((LivingEntity)player) != null;
    }

    private void setup(PlayerEntity player, ByteBuffer startData) {
        this.armSwingAmount = 0.0f;
        this.bodySwingAngleFactor = startData.getDouble();
        this.hangingBarAxis = WorldUtil.getHangableBars((LivingEntity)player);
        Vector3d bodyVec = VectorUtil.fromYawDegree(player.field_70761_aq);
        this.orthogonalToBar = this.hangingBarAxis == BarAxis.X && Math.abs(bodyVec.func_82615_a()) < Math.abs(bodyVec.func_82616_c()) || this.hangingBarAxis == BarAxis.Z && Math.abs(bodyVec.func_82616_c()) < Math.abs(bodyVec.func_82615_a());
        player.func_213293_j(0.0, 0.0, 0.0);
        Animation animation = Animation.get(player);
        if (animation != null) {
            animation.setAnimator(new HangAnimator());
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onStartInLocalClient(PlayerEntity player, Parkourability parkourability, IStamina stamina, ByteBuffer startData) {
        this.setup(player, startData);
        if (ParCoolConfig.Client.Booleans.EnableActionSounds.get().booleanValue()) {
            player.func_184185_a((SoundEvent)SoundEvents.HANG_DOWN.get(), 1.0f, 1.0f);
        }
    }

    @Override
    public void onStartInOtherClient(PlayerEntity player, Parkourability parkourability, ByteBuffer startData) {
        this.setup(player, startData);
        if (ParCoolConfig.Client.Booleans.EnableActionSounds.get().booleanValue()) {
            player.func_184185_a((SoundEvent)SoundEvents.HANG_DOWN.get(), 1.0f, 1.0f);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onWorkingTickInLocalClient(PlayerEntity player, Parkourability parkourability, IStamina stamina) {
        Vector3d bodyVec = VectorUtil.fromYawDegree(player.field_70761_aq);
        double speed = 0.1;
        double xSpeed = 0.0;
        double zSpeed = 0.0;
        if (this.orthogonalToBar) {
            if (this.hangingBarAxis == BarAxis.X) {
                xSpeed = (double)(bodyVec.func_82616_c() > 0.0 ? 1 : -1) * 0.1;
            } else {
                zSpeed = (double)(bodyVec.func_82615_a() > 0.0 ? 1 : -1) * 0.1;
            }
            if (KeyBindings.getKeyLeft().func_151470_d()) {
                player.func_213293_j(xSpeed, 0.0, -zSpeed);
            } else if (KeyBindings.getKeyRight().func_151470_d()) {
                player.func_213293_j(-xSpeed, 0.0, zSpeed);
            } else {
                player.func_213293_j(0.0, 0.0, 0.0);
            }
        } else {
            if (this.hangingBarAxis == BarAxis.X) {
                xSpeed = (double)(bodyVec.func_82615_a() > 0.0 ? 1 : -1) * 0.1;
            } else {
                zSpeed = (double)(bodyVec.func_82616_c() > 0.0 ? 1 : -1) * 0.1;
            }
            if (KeyBindings.getKeyForward().func_151470_d()) {
                player.func_213293_j(xSpeed, 0.0, zSpeed);
            } else if (KeyBindings.getKeyBack().func_151470_d()) {
                player.func_213293_j(-xSpeed, 0.0, -zSpeed);
            } else {
                player.func_213293_j(0.0, 0.0, 0.0);
            }
        }
        this.armSwingAmount += (float)player.func_213322_ci().func_216372_d(1.0, 0.0, 1.0).func_189985_c();
    }

    @Override
    public void onWorkingTickInClient(PlayerEntity player, Parkourability parkourability, IStamina stamina) {
        this.hangingBarAxis = WorldUtil.getHangableBars((LivingEntity)player);
        Vector3d bodyVec = VectorUtil.fromYawDegree(player.field_70761_aq);
        boolean bl = this.orthogonalToBar = this.hangingBarAxis == BarAxis.X && Math.abs(bodyVec.func_82615_a()) < Math.abs(bodyVec.func_82616_c()) || this.hangingBarAxis == BarAxis.Z && Math.abs(bodyVec.func_82616_c()) < Math.abs(bodyVec.func_82615_a());
        this.bodySwingAngleFactor = this.orthogonalToBar ? (this.bodySwingAngleFactor /= 1.05) : (this.bodySwingAngleFactor /= 1.5);
    }

    @Override
    public void saveSynchronizedState(ByteBuffer buffer) {
        buffer.putFloat(this.armSwingAmount);
    }

    @Override
    public void restoreSynchronizedState(ByteBuffer buffer) {
        this.armSwingAmount = buffer.getFloat();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onRenderTick(TickEvent.RenderTickEvent event, PlayerEntity player, Parkourability parkourability) {
        if (this.isDoing()) {
            if (this.hangingBarAxis == null) {
                return;
            }
            Vector3d bodyVec = VectorUtil.fromYawDegree(player.field_70761_aq).func_72432_b();
            Vector3d lookVec = player.func_70040_Z();
            Vector3d idealLookVec = Math.abs(lookVec.func_82615_a()) > Math.abs(lookVec.func_82616_c()) ? new Vector3d(lookVec.func_82615_a() > 0.0 ? 1.0 : -1.0, 0.0, 0.0) : new Vector3d(0.0, 0.0, lookVec.func_82616_c() > 0.0 ? 1.0 : -1.0);
            double differenceAngle = Math.acos(bodyVec.func_72430_b(idealLookVec));
            player.func_181013_g((float)VectorUtil.toYawDegree(idealLookVec.func_178785_b((float)(differenceAngle /= 4.0))));
        }
    }

    @Override
    public StaminaConsumeTiming getStaminaConsumeTiming() {
        return StaminaConsumeTiming.OnWorking;
    }

    public static enum BarAxis {
        X,
        Z;

    }
}

