/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.action.impl;

import com.alrex.parcool.api.SoundEvents;
import com.alrex.parcool.client.animation.impl.HorizontalWallRunAnimator;
import com.alrex.parcool.client.input.KeyBindings;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.StaminaConsumeTiming;
import com.alrex.parcool.common.action.impl.Crawl;
import com.alrex.parcool.common.action.impl.Dodge;
import com.alrex.parcool.common.action.impl.FastRun;
import com.alrex.parcool.common.action.impl.Vault;
import com.alrex.parcool.common.action.impl.WallJump;
import com.alrex.parcool.common.capability.Animation;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.common.info.ActionInfo;
import com.alrex.parcool.config.ParCoolConfig;
import com.alrex.parcool.utilities.BufferUtil;
import com.alrex.parcool.utilities.VectorUtil;
import com.alrex.parcool.utilities.WorldUtil;
import java.nio.ByteBuffer;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;

public class HorizontalWallRun
extends Action {
    private int coolTime = 0;
    private float bodyYaw = 0.0f;
    private boolean wallIsRightward = false;
    private Vector3d runningWallDirection = null;
    private Vector3d runningDirection = null;

    private int getMaxRunningTick(ActionInfo info) {
        Integer value = info.getClientSetting().get(ParCoolConfig.Client.Integers.WallRunContinuableTick);
        if (value == null) {
            value = ParCoolConfig.Client.Integers.WallRunContinuableTick.DefaultValue;
        }
        return Math.min(value, info.getServerLimitation().get(ParCoolConfig.Server.Integers.MaxWallRunContinuableTick));
    }

    @Override
    public void onClientTick(PlayerEntity player, Parkourability parkourability, IStamina stamina) {
        if (this.coolTime > 0) {
            --this.coolTime;
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onWorkingTickInLocalClient(PlayerEntity player, Parkourability parkourability, IStamina stamina) {
        Vector3d wallDirection = WorldUtil.getRunnableWall((LivingEntity)player, player.func_213311_cf() / 2.0f);
        if (wallDirection == null) {
            return;
        }
        if (this.runningWallDirection == null) {
            return;
        }
        if (this.runningDirection == null) {
            return;
        }
        Vector3d lookVec = VectorUtil.fromYawDegree(player.field_70761_aq);
        double differenceAngle = Math.asin(new Vector3d(lookVec.func_82615_a() * this.runningDirection.func_82615_a() + lookVec.func_82616_c() * this.runningDirection.func_82616_c(), 0.0, -lookVec.func_82615_a() * this.runningDirection.func_82616_c() + lookVec.func_82616_c() * this.runningDirection.func_82615_a()).func_72432_b().func_82616_c());
        this.bodyYaw = (float)VectorUtil.toYawDegree(lookVec.func_178785_b((float)(differenceAngle / 10.0)));
        Vector3d movement = player.func_213322_ci();
        BlockPos leanedBlock = new BlockPos(player.func_226277_ct_() + this.runningWallDirection.func_82615_a(), player.func_174813_aQ().field_72338_b + (double)player.func_213302_cg() * 0.5, player.func_226281_cx_() + this.runningWallDirection.func_82616_c());
        if (!player.field_70170_p.func_195588_v(leanedBlock)) {
            return;
        }
        float slipperiness = player.field_70170_p.func_180495_p(leanedBlock).getSlipperiness((IWorldReader)player.field_70170_p, leanedBlock, (Entity)player);
        if ((double)slipperiness <= 0.8) {
            double speedScale = 0.2;
            ModifiableAttributeInstance attr = player.func_110148_a(Attributes.field_233821_d_);
            if (attr != null) {
                speedScale *= attr.func_111126_e() / attr.func_111125_b();
            }
            player.func_213293_j(this.runningDirection.func_82615_a() * speedScale, movement.func_82617_b() * ((double)slipperiness - 0.1) * (double)this.getDoingTick() / (double)this.getMaxRunningTick(parkourability.getActionInfo()), this.runningDirection.func_82616_c() * speedScale);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canStart(PlayerEntity player, Parkourability parkourability, IStamina stamina, ByteBuffer startInfo) {
        Vector3d wallDirection = WorldUtil.getRunnableWall((LivingEntity)player, player.func_213311_cf() / 2.0f);
        if (wallDirection == null) {
            return false;
        }
        Vector3d wallVec = wallDirection.func_72432_b();
        Vector3d lookDirection = VectorUtil.fromYawDegree(player.field_70761_aq);
        lookDirection = new Vector3d(lookDirection.func_82615_a(), 0.0, lookDirection.func_82616_c()).func_72432_b();
        Vector3d dividedVec = new Vector3d(wallVec.func_82615_a() * lookDirection.func_82615_a() + wallVec.func_82616_c() * lookDirection.func_82616_c(), 0.0, -wallVec.func_82615_a() * lookDirection.func_82616_c() + wallVec.func_82616_c() * lookDirection.func_82615_a()).func_72432_b();
        if (Math.abs(dividedVec.func_82616_c()) < 0.9) {
            return false;
        }
        BufferUtil.wrap(startInfo).putBoolean(dividedVec.func_82616_c() > 0.0);
        Vector3d runDirection = wallVec.func_178785_b(1.5707964f);
        if (runDirection.func_72430_b(lookDirection) < 0.0) {
            runDirection = runDirection.func_216371_e();
        }
        startInfo.putDouble(wallDirection.func_82615_a()).putDouble(wallDirection.func_82616_c()).putDouble(runDirection.func_82615_a()).putDouble(runDirection.func_82616_c());
        return !parkourability.get(WallJump.class).justJumped() && (ParCoolConfig.Client.HWallRunControl.get() == ControlType.PressKey && KeyBindings.getKeyHorizontalWallRun().func_151470_d() || ParCoolConfig.Client.HWallRunControl.get() == ControlType.Auto) && !parkourability.get(Crawl.class).isDoing() && !parkourability.get(Dodge.class).isDoing() && !parkourability.get(Vault.class).isDoing() && !player.func_203005_aq() && Math.abs(player.func_213322_ci().func_82617_b()) < 0.5 && this.coolTime == 0 && !player.func_233570_aj_() && parkourability.getAdditionalProperties().getNotLandingTick() > 5 && (parkourability.get(FastRun.class).canActWithRunning(player) || parkourability.get(FastRun.class).getNotDashTick(parkourability.getAdditionalProperties()) < 10) && !stamina.isExhausted();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canContinue(PlayerEntity player, Parkourability parkourability, IStamina stamina) {
        Vector3d wallDirection = WorldUtil.getRunnableWall((LivingEntity)player, player.func_213311_cf() / 2.0f);
        if (wallDirection == null) {
            return false;
        }
        return this.getDoingTick() < this.getMaxRunningTick(parkourability.getActionInfo()) && !stamina.isExhausted() && !parkourability.get(WallJump.class).justJumped() && !parkourability.get(Crawl.class).isDoing() && !parkourability.get(Dodge.class).isDoing() && !parkourability.get(Vault.class).isDoing() && (ParCoolConfig.Client.HWallRunControl.get() == ControlType.PressKey && KeyBindings.getKeyHorizontalWallRun().func_151470_d() || ParCoolConfig.Client.HWallRunControl.get() == ControlType.Auto) && !player.func_233570_aj_();
    }

    @Override
    public void onStop(PlayerEntity player) {
        this.coolTime = 10;
    }

    @Override
    public void onStartInLocalClient(PlayerEntity player, Parkourability parkourability, IStamina stamina, ByteBuffer startData) {
        Animation animation;
        this.wallIsRightward = BufferUtil.getBoolean(startData);
        this.runningWallDirection = new Vector3d(startData.getDouble(), 0.0, startData.getDouble());
        this.runningDirection = new Vector3d(startData.getDouble(), 0.0, startData.getDouble());
        if (ParCoolConfig.Client.Booleans.EnableActionSounds.get().booleanValue()) {
            player.func_184185_a((SoundEvent)SoundEvents.HORIZONTAL_WALL_RUN.get(), 1.0f, 1.0f);
        }
        if ((animation = Animation.get(player)) != null) {
            animation.setAnimator(new HorizontalWallRunAnimator(this.wallIsRightward));
        }
    }

    @Override
    public void onStartInOtherClient(PlayerEntity player, Parkourability parkourability, ByteBuffer startData) {
        this.wallIsRightward = BufferUtil.getBoolean(startData);
        this.runningWallDirection = new Vector3d(startData.getDouble(), 0.0, startData.getDouble());
        this.runningDirection = new Vector3d(startData.getDouble(), 0.0, startData.getDouble());
        Animation animation = Animation.get(player);
        if (ParCoolConfig.Client.Booleans.EnableActionSounds.get().booleanValue()) {
            player.func_184185_a((SoundEvent)SoundEvents.HORIZONTAL_WALL_RUN.get(), 1.0f, 1.0f);
        }
        if (animation != null) {
            animation.setAnimator(new HorizontalWallRunAnimator(this.wallIsRightward));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onRenderTick(TickEvent.RenderTickEvent event, PlayerEntity player, Parkourability parkourability) {
        if (this.isDoing()) {
            if (this.runningDirection == null) {
                return;
            }
            Vector3d lookVec = VectorUtil.fromYawDegree(player.func_70079_am());
            double differenceAngle = Math.asin(new Vector3d(lookVec.func_82615_a() * this.runningDirection.func_82615_a() + lookVec.func_82616_c() * this.runningDirection.func_82616_c(), 0.0, -lookVec.func_82615_a() * this.runningDirection.func_82616_c() + lookVec.func_82616_c() * this.runningDirection.func_82615_a()).func_72432_b().func_82616_c());
            if (Math.abs(differenceAngle) > 0.7853981633974483) {
                player.field_70177_z = (float)VectorUtil.toYawDegree(this.runningDirection.func_178785_b((float)(-Math.signum(differenceAngle) * Math.PI / 4.0)));
            }
            player.field_70760_ar = player.field_70761_aq = this.bodyYaw;
        }
    }

    @Override
    public void onWorkingTickInClient(PlayerEntity player, Parkourability parkourability, IStamina stamina) {
        this.spawnRunningParticle(player);
    }

    @Override
    public void saveSynchronizedState(ByteBuffer buffer) {
        buffer.putFloat(this.bodyYaw);
    }

    @Override
    public void restoreSynchronizedState(ByteBuffer buffer) {
        this.bodyYaw = buffer.getFloat();
    }

    @Override
    public StaminaConsumeTiming getStaminaConsumeTiming() {
        return StaminaConsumeTiming.OnWorking;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void spawnRunningParticle(PlayerEntity player) {
        if (this.runningDirection == null || this.runningWallDirection == null) {
            return;
        }
        World level = player.field_70170_p;
        Vector3d pos = player.func_213303_ch();
        BlockPos leanedBlock = new BlockPos(pos.func_72441_c(this.runningWallDirection.func_82615_a(), (double)player.func_213302_cg() * 0.25, this.runningWallDirection.func_82616_c()));
        if (!level.func_195588_v(leanedBlock)) {
            return;
        }
        float width = player.func_213311_cf();
        BlockState blockstate = level.func_180495_p(leanedBlock);
        Vector3d wallDirection = this.runningWallDirection.func_72432_b();
        Vector3d orthogonalToWallVec = wallDirection.func_178785_b(1.5707964f);
        Vector3d particleBaseDirection = this.runningDirection.func_178788_d(wallDirection);
        if (blockstate.func_185901_i() != BlockRenderType.INVISIBLE) {
            Vector3d particlePos = new Vector3d(pos.func_82615_a() + (wallDirection.func_82615_a() * 0.4 + orthogonalToWallVec.func_82615_a() * (player.func_70681_au().nextDouble() - 0.5)) * (double)width, pos.func_82617_b() + 0.1 + 0.3 * player.func_70681_au().nextDouble(), pos.func_82616_c() + (wallDirection.func_82616_c() * 0.4 + orthogonalToWallVec.func_82616_c() * (player.func_70681_au().nextDouble() - 0.5)) * (double)width);
            Vector3d particleSpeed = particleBaseDirection.func_178785_b((float)(0.6283185307179586 * (player.func_70681_au().nextDouble() - 0.5))).func_186678_a(3.0 + 6.0 * player.func_70681_au().nextDouble()).func_72441_c(0.0, 1.5, 0.0);
            level.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, blockstate).setPos(leanedBlock), particlePos.func_82615_a(), particlePos.func_82617_b(), particlePos.func_82616_c(), particleSpeed.func_82615_a(), particleSpeed.func_82617_b(), particleSpeed.func_82616_c());
        }
    }

    public static enum ControlType {
        PressKey,
        Auto;

    }
}

