/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.action.impl;

import com.alrex.parcool.client.input.KeyRecorder;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.StaminaConsumeTiming;
import com.alrex.parcool.common.action.impl.ClingToCliff;
import com.alrex.parcool.common.action.impl.Flipping;
import com.alrex.parcool.common.action.impl.Roll;
import com.alrex.parcool.common.action.impl.Vault;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.utilities.VectorUtil;
import java.nio.ByteBuffer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.event.TickEvent;

public class QuickTurn
extends Action {
    private static final int AnimationTickLength = 4;
    private boolean turnRightward = false;
    private Vector3d startAngle = null;

    @Override
    public boolean canStart(PlayerEntity player, Parkourability parkourability, IStamina stamina, ByteBuffer startInfo) {
        Vector3d angle = player.func_70040_Z();
        startInfo.putDouble(angle.func_82615_a()).putDouble(angle.func_82616_c());
        return KeyRecorder.keyQuickTurn.isPressed() && !parkourability.get(Vault.class).isDoing() && !parkourability.get(Roll.class).isDoing() && !parkourability.get(Flipping.class).isDoing() && !parkourability.get(ClingToCliff.class).isDoing();
    }

    @Override
    public boolean canContinue(PlayerEntity player, Parkourability parkourability, IStamina stamina) {
        return this.getDoingTick() < 4;
    }

    @Override
    public void onStartInLocalClient(PlayerEntity player, Parkourability parkourability, IStamina stamina, ByteBuffer startData) {
        this.turnRightward = !this.turnRightward;
        this.startAngle = new Vector3d(startData.getDouble(), 0.0, startData.getDouble()).func_72432_b();
    }

    @Override
    public void onRenderTick(TickEvent.RenderTickEvent event, PlayerEntity player, Parkourability parkourability) {
        if (this.isDoing() && this.startAngle != null) {
            float renderTick = (float)this.getDoingTick() + event.renderTickTime;
            float animationPhase = renderTick / 4.0f;
            Vector3d rotatedAngle = this.startAngle.func_178785_b((float)(Math.PI * (double)animationPhase * (double)(this.turnRightward ? -1 : 1)));
            player.field_70177_z = (float)VectorUtil.toYawDegree(rotatedAngle);
        }
    }

    @Override
    public StaminaConsumeTiming getStaminaConsumeTiming() {
        return StaminaConsumeTiming.None;
    }
}

