/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.action.impl;

import com.alrex.parcool.client.animation.impl.RollAnimator;
import com.alrex.parcool.client.input.KeyBindings;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.StaminaConsumeTiming;
import com.alrex.parcool.common.action.impl.Crawl;
import com.alrex.parcool.common.action.impl.Dodge;
import com.alrex.parcool.common.capability.Animation;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.config.ParCoolConfig;
import com.alrex.parcool.utilities.VectorUtil;
import java.nio.ByteBuffer;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Roll
extends Action {
    private int creativeCoolTime = 0;
    private boolean startRequired = false;

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onClientTick(PlayerEntity player, Parkourability parkourability, IStamina stamina) {
        if (player.func_175144_cb()) {
            if (KeyBindings.getKeyBreakfall().func_151470_d() && KeyBindings.getKeyForward().func_151470_d() && !parkourability.get(Dodge.class).isDoing() && !parkourability.get(Crawl.class).isDoing() && !player.func_213300_bk() && !player.func_213314_bj() && ParCoolConfig.Client.Booleans.EnableRollWhenCreative.get().booleanValue() && player.func_184812_l_() && parkourability.getAdditionalProperties().getLandingTick() <= 1 && player.func_233570_aj_() && !this.isDoing() && this.creativeCoolTime == 0) {
                this.startRequired = true;
                this.creativeCoolTime = 20;
            }
            if (this.creativeCoolTime > 0) {
                --this.creativeCoolTime;
            }
        }
    }

    @Override
    public StaminaConsumeTiming getStaminaConsumeTiming() {
        return StaminaConsumeTiming.OnStart;
    }

    @Override
    public boolean canStart(PlayerEntity player, Parkourability parkourability, IStamina stamina, ByteBuffer startInfo) {
        ClientPlayerEntity clientPlayer = (ClientPlayerEntity)player;
        Direction rollDirection = Direction.Front;
        if ((double)clientPlayer.field_71158_b.field_78902_a < -0.5) {
            rollDirection = Direction.Right;
        } else if ((double)clientPlayer.field_71158_b.field_78902_a > 0.5) {
            rollDirection = Direction.Left;
        } else if ((double)clientPlayer.field_71158_b.field_192832_b < -0.5) {
            rollDirection = Direction.Back;
        }
        startInfo.putInt(rollDirection.ordinal());
        return this.startRequired;
    }

    @Override
    public boolean canContinue(PlayerEntity player, Parkourability parkourability, IStamina stamina) {
        return this.getDoingTick() < this.getRollMaxTick();
    }

    @Override
    public void onStartInOtherClient(PlayerEntity player, Parkourability parkourability, ByteBuffer startData) {
        this.startRequired = false;
        Direction direction = Direction.values()[startData.getInt()];
        Animation animation = Animation.get(player);
        if (animation != null) {
            animation.setAnimator(new RollAnimator(direction));
        }
    }

    @Override
    public void onStartInLocalClient(PlayerEntity player, Parkourability parkourability, IStamina stamina, ByteBuffer startData) {
        this.startRequired = false;
        Direction direction = Direction.values()[startData.getInt()];
        double modifier = Math.sqrt(player.func_213311_cf());
        Vector3d vec = VectorUtil.fromYawDegree(player.field_70761_aq).func_186678_a(modifier);
        switch (direction) {
            case Back: {
                vec = vec.func_216371_e();
                break;
            }
            case Right: {
                vec = vec.func_178785_b(-1.5707964f);
                break;
            }
            case Left: {
                vec = vec.func_178785_b(1.5707964f);
            }
        }
        player.func_213293_j(vec.func_82615_a(), 0.0, vec.func_82616_c());
        Animation animation = Animation.get(player);
        if (animation != null) {
            animation.setAnimator(new RollAnimator(direction));
        }
        parkourability.getCancelMarks().addMarkerCancellingJump(this::isDoing);
    }

    public void startRoll(PlayerEntity player) {
        this.startRequired = true;
    }

    public int getRollMaxTick() {
        return 9;
    }

    public static enum Direction {
        Front,
        Back,
        Left,
        Right;

    }
}

