/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.action.impl;

import com.alrex.parcool.api.SoundEvents;
import com.alrex.parcool.client.animation.impl.CrawlAnimator;
import com.alrex.parcool.client.animation.impl.SlidingAnimator;
import com.alrex.parcool.client.input.KeyRecorder;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.StaminaConsumeTiming;
import com.alrex.parcool.common.action.impl.Crawl;
import com.alrex.parcool.common.action.impl.FastRun;
import com.alrex.parcool.common.action.impl.Roll;
import com.alrex.parcool.common.action.impl.Tap;
import com.alrex.parcool.common.capability.Animation;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.config.ParCoolConfig;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Slide
extends Action {
    private Vector3d slidingVec = null;

    @Override
    public boolean canStart(PlayerEntity player, Parkourability parkourability, IStamina stamina, ByteBuffer startInfo) {
        Vector3d lookingVec = player.func_70040_Z().func_216372_d(1.0, 0.0, 1.0).func_72432_b();
        startInfo.putDouble(lookingVec.func_82615_a()).putDouble(lookingVec.func_82616_c());
        return !stamina.isExhausted() && KeyRecorder.keyCrawlState.isPressed() && player.func_233570_aj_() && !parkourability.get(Roll.class).isDoing() && !parkourability.get(Tap.class).isDoing() && parkourability.get(Crawl.class).isDoing() && !player.func_203005_aq() && parkourability.get(FastRun.class).getDashTick(parkourability.getAdditionalProperties()) > 5;
    }

    @Override
    public boolean canContinue(PlayerEntity player, Parkourability parkourability, IStamina stamina) {
        int maxSlidingTick = Math.min(parkourability.getActionInfo().getClientSetting().get(ParCoolConfig.Client.Integers.SlidingContinuableTick), parkourability.getActionInfo().getServerLimitation().get(ParCoolConfig.Server.Integers.MaxSlidingContinuableTick));
        return this.getDoingTick() < maxSlidingTick && parkourability.get(Crawl.class).isDoing();
    }

    @Override
    public void onStartInLocalClient(PlayerEntity player, Parkourability parkourability, IStamina stamina, ByteBuffer startData) {
        Animation animation;
        this.slidingVec = new Vector3d(startData.getDouble(), 0.0, startData.getDouble());
        if (ParCoolConfig.Client.Booleans.EnableActionSounds.get().booleanValue()) {
            player.func_184185_a((SoundEvent)SoundEvents.SLIDE.get(), 1.0f, 1.0f);
        }
        if ((animation = Animation.get(player)) != null) {
            animation.setAnimator(new SlidingAnimator());
        }
        parkourability.getCancelMarks().addMarkerCancellingJump(this::isDoing);
    }

    @Override
    public void onStartInOtherClient(PlayerEntity player, Parkourability parkourability, ByteBuffer startData) {
        Animation animation;
        this.slidingVec = new Vector3d(startData.getDouble(), 0.0, startData.getDouble());
        if (ParCoolConfig.Client.Booleans.EnableActionSounds.get().booleanValue()) {
            player.func_184185_a((SoundEvent)SoundEvents.SLIDE.get(), 1.0f, 1.0f);
        }
        if ((animation = Animation.get(player)) != null) {
            animation.setAnimator(new SlidingAnimator());
        }
    }

    @Override
    public void onWorkingTickInLocalClient(PlayerEntity player, Parkourability parkourability, IStamina stamina) {
        if (this.slidingVec != null) {
            ModifiableAttributeInstance attr = player.func_110148_a(Attributes.field_233821_d_);
            double speedScale = 0.45;
            if (attr != null) {
                speedScale = attr.func_111126_e() * 4.5;
            }
            Vector3d vec = this.slidingVec.func_186678_a(speedScale);
            player.func_213317_d((player.func_233570_aj_() ? vec : vec.func_186678_a(0.6)).func_72441_c(0.0, player.func_213322_ci().func_82617_b(), 0.0));
        }
    }

    @Override
    public void onWorkingTickInClient(PlayerEntity player, Parkourability parkourability, IStamina stamina) {
        this.spawnSlidingParticle(player);
    }

    @Override
    public void onStopInLocalClient(PlayerEntity player) {
        Animation animation = Animation.get(player);
        if (animation != null && !animation.hasAnimator()) {
            animation.setAnimator(new CrawlAnimator());
        }
    }

    @Override
    public void onStopInOtherClient(PlayerEntity player) {
        Animation animation = Animation.get(player);
        if (animation != null && !animation.hasAnimator()) {
            animation.setAnimator(new CrawlAnimator());
        }
    }

    @Nullable
    public Vector3d getSlidingVector() {
        return this.slidingVec;
    }

    @Override
    public StaminaConsumeTiming getStaminaConsumeTiming() {
        return StaminaConsumeTiming.None;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnSlidingParticle(PlayerEntity player) {
        World level = player.field_70170_p;
        Vector3d pos = player.func_213303_ch();
        BlockState feetBlock = player.field_70170_p.func_180495_p(player.func_233580_cy_().func_177977_b());
        float width = player.func_213311_cf();
        Vector3d direction = this.getSlidingVector();
        if (direction == null) {
            return;
        }
        if (feetBlock.func_185901_i() != BlockRenderType.INVISIBLE) {
            Vector3d particlePos = new Vector3d(pos.func_82615_a() + (player.func_70681_au().nextDouble() - 0.5) * (double)width, pos.func_82617_b() + 0.01 + 0.2 * player.func_70681_au().nextDouble(), pos.func_82616_c() + (player.func_70681_au().nextDouble() - 0.5) * (double)width);
            Vector3d particleSpeed = direction.func_216371_e().func_186678_a(2.5 + 5.0 * player.func_70681_au().nextDouble()).func_72441_c(0.0, 1.5, 0.0);
            level.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, feetBlock).setPos(new BlockPos(player.func_213303_ch().func_72441_c(0.0, -0.5, 0.0))), particlePos.func_82615_a(), particlePos.func_82617_b(), particlePos.func_82616_c(), particleSpeed.func_82615_a(), particleSpeed.func_82617_b(), particleSpeed.func_82616_c());
        }
    }
}

