/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.action.impl;

import com.alrex.parcool.api.SoundEvents;
import com.alrex.parcool.client.animation.impl.KongVaultAnimator;
import com.alrex.parcool.client.animation.impl.SpeedVaultAnimator;
import com.alrex.parcool.client.input.KeyBindings;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.StaminaConsumeTiming;
import com.alrex.parcool.common.action.impl.FastRun;
import com.alrex.parcool.common.capability.Animation;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.config.ParCoolConfig;
import com.alrex.parcool.utilities.BufferUtil;
import com.alrex.parcool.utilities.WorldUtil;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Vault
extends Action {
    public static final int MAX_TICK = 11;
    private double stepHeight = 0.0;
    private Vector3d stepDirection = null;

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canStart(PlayerEntity player, Parkourability parkourability, IStamina stamina, ByteBuffer startInfo) {
        Vector3d lookVec = player.func_70040_Z();
        lookVec = new Vector3d(lookVec.func_82615_a(), 0.0, lookVec.func_82616_c()).func_72432_b();
        Vector3d step = WorldUtil.getVaultableStep((LivingEntity)player);
        if (step == null) {
            return false;
        }
        step = step.func_72432_b();
        Vector3d dividedVec = new Vector3d(lookVec.func_82615_a() * step.func_82615_a() + lookVec.func_82616_c() * step.func_82616_c(), 0.0, -lookVec.func_82615_a() * step.func_82616_c() + lookVec.func_82616_c() * step.func_82615_a()).func_72432_b();
        if (dividedVec.func_82615_a() < 0.707106) {
            return false;
        }
        AnimationType animationType = null;
        SpeedVaultAnimator.Type type = SpeedVaultAnimator.Type.Right;
        switch ((TypeSelectionMode)((Object)ParCoolConfig.Client.VaultAnimationMode.get())) {
            case KongVault: {
                animationType = AnimationType.KongVault;
                break;
            }
            case SpeedVault: {
                animationType = AnimationType.SpeedVault;
                type = dividedVec.func_82616_c() > 0.0 ? SpeedVaultAnimator.Type.Right : SpeedVaultAnimator.Type.Left;
                break;
            }
            default: {
                if (dividedVec.func_82615_a() > 0.99) {
                    animationType = AnimationType.KongVault;
                    break;
                }
                animationType = AnimationType.SpeedVault;
                type = dividedVec.func_82616_c() > 0.0 ? SpeedVaultAnimator.Type.Right : SpeedVaultAnimator.Type.Left;
            }
        }
        double wallHeight = WorldUtil.getWallHeight((LivingEntity)player);
        startInfo.put(animationType.getCode());
        BufferUtil.wrap(startInfo).putBoolean(type == SpeedVaultAnimator.Type.Right);
        startInfo.putDouble(step.func_82615_a()).putDouble(step.func_82617_b()).putDouble(step.func_82616_c()).putDouble(wallHeight);
        return !(stamina.isExhausted() || ParCoolConfig.Client.Booleans.VaultKeyPressedNeeded.get() != false && !KeyBindings.getKeyVault().func_151470_d() || !parkourability.get(FastRun.class).canActWithRunning(player) || stamina.isExhausted() || !player.func_233570_aj_() && ParCoolConfig.Client.Booleans.EnableVaultInAir.get() == false || !(wallHeight > (double)player.func_213302_cg() * 0.44));
    }

    @Override
    public boolean canContinue(PlayerEntity player, Parkourability parkourability, IStamina stamina) {
        return this.getDoingTick() < 11;
    }

    private int getVaultAnimateTime() {
        return 2;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onStartInLocalClient(PlayerEntity player, Parkourability parkourability, IStamina stamina, ByteBuffer startData) {
        SpeedVaultAnimator.Type speedVaultType;
        AnimationType animationType = AnimationType.fromCode(startData.get());
        SpeedVaultAnimator.Type type = speedVaultType = BufferUtil.getBoolean(startData) ? SpeedVaultAnimator.Type.Right : SpeedVaultAnimator.Type.Left;
        if (ParCoolConfig.Client.Booleans.EnableActionSounds.get().booleanValue()) {
            player.func_184185_a((SoundEvent)SoundEvents.VAULT.get(), 1.0f, 1.0f);
        }
        this.stepDirection = new Vector3d(startData.getDouble(), startData.getDouble(), startData.getDouble());
        this.stepHeight = startData.getDouble();
        Animation animation = Animation.get(player);
        if (animation != null && animationType != null) {
            switch (animationType) {
                case SpeedVault: {
                    animation.setAnimator(new SpeedVaultAnimator(speedVaultType));
                    break;
                }
                case KongVault: {
                    animation.setAnimator(new KongVaultAnimator());
                }
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onStartInOtherClient(PlayerEntity player, Parkourability parkourability, ByteBuffer startData) {
        Animation animation;
        SpeedVaultAnimator.Type speedVaultType;
        AnimationType animationType = AnimationType.fromCode(startData.get());
        SpeedVaultAnimator.Type type = speedVaultType = BufferUtil.getBoolean(startData) ? SpeedVaultAnimator.Type.Right : SpeedVaultAnimator.Type.Left;
        if (ParCoolConfig.Client.Booleans.EnableActionSounds.get().booleanValue()) {
            player.func_184185_a((SoundEvent)SoundEvents.VAULT.get(), 1.0f, 1.0f);
        }
        if ((animation = Animation.get(player)) != null && animationType != null) {
            switch (animationType) {
                case SpeedVault: {
                    animation.setAnimator(new SpeedVaultAnimator(speedVaultType));
                    break;
                }
                case KongVault: {
                    animation.setAnimator(new KongVaultAnimator());
                }
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onWorkingTickInLocalClient(PlayerEntity player, Parkourability parkourability, IStamina stamina) {
        if (this.stepDirection == null) {
            return;
        }
        if (this.getDoingTick() < this.getVaultAnimateTime()) {
            player.func_213293_j(this.stepDirection.func_82615_a() / 10.0, (this.stepHeight + 0.02) / (double)this.getVaultAnimateTime() / ((double)player.func_213302_cg() / 1.8), this.stepDirection.func_82616_c() / 10.0);
        } else if (this.getDoingTick() == this.getVaultAnimateTime()) {
            this.stepDirection = this.stepDirection.func_72432_b();
            player.func_213293_j(this.stepDirection.func_82615_a() * 0.45, 0.075 * ((double)player.func_213302_cg() / 1.8), this.stepDirection.func_82616_c() * 0.45);
        }
    }

    @Override
    public StaminaConsumeTiming getStaminaConsumeTiming() {
        return StaminaConsumeTiming.OnStart;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onStopInLocalClient(PlayerEntity player) {
    }

    public static enum AnimationType {
        SpeedVault(0),
        KongVault(1);

        private final byte code;

        private AnimationType(byte code) {
            this.code = code;
        }

        public byte getCode() {
            return this.code;
        }

        @Nullable
        public static AnimationType fromCode(byte code) {
            switch (code) {
                case 0: {
                    return SpeedVault;
                }
                case 1: {
                    return KongVault;
                }
            }
            return null;
        }
    }

    public static enum TypeSelectionMode {
        SpeedVault,
        KongVault,
        Dynamic;

    }
}

