/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.action.impl;

import com.alrex.parcool.api.SoundEvents;
import com.alrex.parcool.client.animation.impl.VerticalWallRunAnimator;
import com.alrex.parcool.client.input.KeyBindings;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.StaminaConsumeTiming;
import com.alrex.parcool.common.action.impl.CatLeap;
import com.alrex.parcool.common.action.impl.ClingToCliff;
import com.alrex.parcool.common.action.impl.Crawl;
import com.alrex.parcool.common.action.impl.FastRun;
import com.alrex.parcool.common.action.impl.Flipping;
import com.alrex.parcool.common.action.impl.HorizontalWallRun;
import com.alrex.parcool.common.action.impl.Vault;
import com.alrex.parcool.common.action.impl.WallSlide;
import com.alrex.parcool.common.capability.Animation;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.config.ParCoolConfig;
import com.alrex.parcool.utilities.VectorUtil;
import com.alrex.parcool.utilities.WorldUtil;
import java.nio.ByteBuffer;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;

public class VerticalWallRun
extends Action {
    private double playerYSpeed = 0.0;
    private Vector3d wallDirection = null;

    @Override
    public void onTick(PlayerEntity player, Parkourability parkourability, IStamina stamina) {
        this.playerYSpeed = player.func_213322_ci().func_82617_b();
    }

    @Override
    public boolean canStart(PlayerEntity player, Parkourability parkourability, IStamina stamina, ByteBuffer startInfo) {
        boolean able;
        int tickAfterJump = parkourability.getAdditionalProperties().getTickAfterLastJump();
        Vector3d lookVec = player.func_70040_Z();
        boolean bl = able = !stamina.isExhausted() && Math.abs(player.func_213322_ci().func_82617_b()) <= (double)(player.func_213302_cg() / 5.0f) && 4 < tickAfterJump && tickAfterJump < 13 && this.getNotDoingTick() > 15 && !player.func_184613_cA() && KeyBindings.getKeyJump().func_151470_d() && !parkourability.get(ClingToCliff.class).isDoing() && !parkourability.get(Crawl.class).isDoing() && !parkourability.get(CatLeap.class).isDoing() && !parkourability.get(WallSlide.class).isDoing() && !parkourability.get(HorizontalWallRun.class).isDoing() && !parkourability.get(Vault.class).isDoing() && !parkourability.get(Flipping.class).isDoing() && parkourability.get(FastRun.class).getNotDashTick(parkourability.getAdditionalProperties()) < 8 && parkourability.getAdditionalProperties().getLastSprintingTick() > 12 && lookVec.func_82617_b() > 0.0;
        if (able) {
            double height;
            Vector3d wall = WorldUtil.getWall((LivingEntity)player);
            if (wall == null) {
                return false;
            }
            if ((wall = wall.func_72432_b()).func_72430_b(VectorUtil.fromYawDegree(player.func_70079_am())) > 0.93 && (height = WorldUtil.getWallHeight((LivingEntity)player, wall, (double)player.func_213302_cg() * 2.2, 0.2)) > 2.3) {
                BlockPos targetBlock = new BlockPos(player.func_226277_ct_() + wall.func_82615_a(), player.func_174813_aQ().field_72338_b + (double)player.func_213302_cg() * 0.5, player.func_226281_cx_() + wall.func_82616_c());
                if (!player.field_70170_p.func_195588_v(targetBlock)) {
                    return false;
                }
                float slipperiness = player.field_70170_p.func_180495_p(targetBlock).getSlipperiness((IWorldReader)player.field_70170_p, targetBlock, (Entity)player);
                startInfo.putDouble(height);
                startInfo.putFloat(slipperiness);
                startInfo.putDouble(wall.func_82615_a());
                startInfo.putDouble(wall.func_82617_b());
                startInfo.putDouble(wall.func_82616_c());
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canContinue(PlayerEntity player, Parkourability parkourability, IStamina stamina) {
        Vector3d wall = WorldUtil.getWall((LivingEntity)player);
        if (wall == null) {
            return false;
        }
        return (wall = wall.func_72432_b()).func_72430_b(VectorUtil.fromYawDegree(player.func_70079_am())) > 0.93 && this.playerYSpeed > 0.0 || this.getDoingTick() > 30;
    }

    @Override
    public void onStartInLocalClient(PlayerEntity player, Parkourability parkourability, IStamina stamina, ByteBuffer startData) {
        double height = startData.getDouble();
        float slipperiness = startData.getFloat();
        if (ParCoolConfig.Client.Booleans.EnableActionSounds.get().booleanValue()) {
            player.func_184185_a((SoundEvent)SoundEvents.VERTICAL_WALL_RUN.get(), 1.0f, 1.0f);
        }
        player.func_213317_d(player.func_213322_ci().func_216372_d(1.0, 0.0, 1.0).func_72441_c(0.0, (slipperiness <= 0.8f ? 0.32 : 0.16) * Math.sqrt(height), 0.0));
        this.onStartInOtherClient(player, parkourability, startData);
    }

    @Override
    public void onStartInOtherClient(PlayerEntity player, Parkourability parkourability, ByteBuffer startData) {
        Animation animation;
        startData.position(12);
        this.wallDirection = new Vector3d(startData.getDouble(), startData.getDouble(), startData.getDouble());
        if (ParCoolConfig.Client.Booleans.EnableActionSounds.get().booleanValue()) {
            player.func_184185_a((SoundEvent)SoundEvents.VERTICAL_WALL_RUN.get(), 1.0f, 1.0f);
        }
        if ((animation = Animation.get(player)) != null) {
            animation.setAnimator(new VerticalWallRunAnimator());
        }
    }

    @Override
    public void onRenderTick(TickEvent.RenderTickEvent event, PlayerEntity player, Parkourability parkourability) {
        if (this.wallDirection != null && this.isDoing()) {
            player.func_70034_d((float)VectorUtil.toYawDegree(this.wallDirection));
            player.field_70760_ar = player.field_70761_aq = player.func_70079_am();
        }
    }

    @Override
    public void onWorkingTickInClient(PlayerEntity player, Parkourability parkourability, IStamina stamina) {
        this.spawnRunningParticle(player);
    }

    @Override
    public StaminaConsumeTiming getStaminaConsumeTiming() {
        return StaminaConsumeTiming.OnStart;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void spawnRunningParticle(PlayerEntity player) {
        if (this.wallDirection == null) {
            return;
        }
        World level = player.field_70170_p;
        Vector3d pos = player.func_213303_ch();
        BlockPos leanedBlock = new BlockPos(pos.func_72441_c(this.wallDirection.func_82615_a(), (double)player.func_213302_cg() * 0.25, this.wallDirection.func_82616_c()));
        if (!level.func_195588_v(leanedBlock)) {
            return;
        }
        float width = player.func_213311_cf();
        BlockState blockstate = level.func_180495_p(leanedBlock);
        Vector3d normalizedWallVec = this.wallDirection.func_72432_b();
        Vector3d orthogonalToWallVec = normalizedWallVec.func_178785_b(1.5707964f);
        if (blockstate.func_185901_i() != BlockRenderType.INVISIBLE) {
            Vector3d particlePos = new Vector3d(pos.func_82615_a() + (normalizedWallVec.func_82615_a() * 0.4 + orthogonalToWallVec.func_82615_a() * (player.func_70681_au().nextDouble() - 0.5)) * (double)width, pos.func_82617_b() + 0.1 + 0.3 * player.func_70681_au().nextDouble(), pos.func_82616_c() + (normalizedWallVec.func_82616_c() * 0.4 + orthogonalToWallVec.func_82616_c() * (player.func_70681_au().nextDouble() - 0.5)) * (double)width);
            Vector3d particleSpeed = normalizedWallVec.func_216371_e().func_178785_b((float)(0.6283185307179586 * (player.func_70681_au().nextDouble() - 0.5))).func_186678_a(2.0 + 4.0 * player.func_70681_au().nextDouble()).func_72441_c(0.0, 0.5, 0.0);
            level.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, blockstate).setPos(leanedBlock), particlePos.func_82615_a(), particlePos.func_82617_b(), particlePos.func_82616_c(), particleSpeed.func_82615_a(), particleSpeed.func_82617_b(), particleSpeed.func_82616_c());
        }
    }
}

