/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.action.impl;

import com.alrex.parcool.api.SoundEvents;
import com.alrex.parcool.client.animation.impl.BackwardWallJumpAnimator;
import com.alrex.parcool.client.animation.impl.WallJumpAnimator;
import com.alrex.parcool.client.input.KeyRecorder;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.StaminaConsumeTiming;
import com.alrex.parcool.common.action.impl.ClingToCliff;
import com.alrex.parcool.common.action.impl.Crawl;
import com.alrex.parcool.common.action.impl.VerticalWallRun;
import com.alrex.parcool.common.capability.Animation;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.config.ParCoolConfig;
import com.alrex.parcool.utilities.WorldUtil;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class WallJump
extends Action {
    private boolean jump = false;
    private final float MAX_COOL_DOWN_TICK = 8.0f;

    public boolean justJumped() {
        return this.jump;
    }

    @Override
    public void onTick(PlayerEntity player, Parkourability parkourability, IStamina stamina) {
        this.jump = false;
    }

    @Override
    public StaminaConsumeTiming getStaminaConsumeTiming() {
        return StaminaConsumeTiming.OnStart;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    private Vector3d getJumpDirection(PlayerEntity player, Vector3d wall) {
        Vector3d value;
        Vector3d lookVec;
        Vector3d vec;
        if (wall == null) {
            return null;
        }
        double dotProduct = (wall = wall.func_72432_b()).func_72430_b(vec = new Vector3d((lookVec = player.func_70040_Z()).func_82615_a(), 0.0, lookVec.func_82616_c()).func_72432_b());
        if (dotProduct > 0.35 && !ParCoolConfig.Client.Booleans.EnableWallJumpBackward.get().booleanValue()) {
            return null;
        }
        if (dotProduct > 0.0) {
            double dot = vec.func_216371_e().func_72430_b(wall);
            value = vec.func_178787_e(wall.func_186678_a(2.0 * dot / wall.func_72433_c()));
        } else {
            value = vec;
        }
        return value.func_72432_b().func_178787_e(wall.func_186678_a(-0.7)).func_72432_b();
    }

    @Override
    public boolean canStart(PlayerEntity player, Parkourability parkourability, IStamina stamina, ByteBuffer startInfo) {
        boolean value;
        Vector3d wallDirection = WorldUtil.getWall((LivingEntity)player);
        Vector3d jumpDirection = this.getJumpDirection(player, wallDirection);
        if (jumpDirection == null) {
            return false;
        }
        ClingToCliff cling = parkourability.get(ClingToCliff.class);
        boolean bl = value = !stamina.isExhausted() && (float)this.getNotDoingTick() > 8.0f && !player.func_233570_aj_() && !player.func_203005_aq() && !player.func_184613_cA() && !player.field_71075_bZ.field_75100_b && parkourability.getAdditionalProperties().getNotCreativeFlyingTick() > 10 && (!cling.isDoing() && cling.getNotDoingTick() > 3 || cling.isDoing() && cling.getFacingDirection() != ClingToCliff.FacingDirection.ToWall) && KeyRecorder.keyWallJump.isPressed() && !parkourability.get(Crawl.class).isDoing() && !parkourability.get(VerticalWallRun.class).isDoing() && parkourability.getAdditionalProperties().getNotLandingTick() > 4 && WorldUtil.getWall((LivingEntity)player) != null;
        if (!value) {
            return false;
        }
        Vector3d dividedVec = new Vector3d(wallDirection.func_82615_a() * jumpDirection.func_82615_a() + wallDirection.func_82616_c() * jumpDirection.func_82616_c(), 0.0, -wallDirection.func_82615_a() * jumpDirection.func_82616_c() + wallDirection.func_82616_c() * jumpDirection.func_82615_a()).func_72432_b();
        Vector3d lookVec = player.func_70040_Z().func_216372_d(1.0, 0.0, 1.0).func_72432_b();
        Vector3d lookDividedVec = new Vector3d(lookVec.func_82615_a() * wallDirection.func_82615_a() + lookVec.func_82616_c() * wallDirection.func_82616_c(), 0.0, -lookVec.func_82615_a() * wallDirection.func_82616_c() + lookVec.func_82616_c() * wallDirection.func_82615_a()).func_72432_b();
        WallJumpAnimationType type = lookDividedVec.func_82615_a() > 0.707 ? WallJumpAnimationType.Back : (dividedVec.func_82616_c() > 0.0 ? WallJumpAnimationType.SwingRightArm : WallJumpAnimationType.SwingLeftArm);
        double lookAngleY = player.func_70040_Z().func_72432_b().func_82617_b();
        jumpDirection = lookAngleY > 0.5 ? jumpDirection.func_72441_c(0.0, lookAngleY * 2.0, 0.0).func_72432_b() : jumpDirection.func_72441_c(0.0, 1.0, 0.0).func_72432_b();
        startInfo.putDouble(jumpDirection.func_82615_a()).putDouble(jumpDirection.func_82617_b()).putDouble(jumpDirection.func_82616_c()).putDouble(wallDirection.func_82615_a()).putDouble(wallDirection.func_82616_c()).put(type.getCode());
        return true;
    }

    @Override
    public boolean canContinue(PlayerEntity player, Parkourability parkourability, IStamina stamina) {
        return false;
    }

    @Override
    public void onStart(PlayerEntity player, Parkourability parkourability) {
        this.jump = true;
        player.field_70143_R = 0.0f;
    }

    @Override
    public void onStartInLocalClient(PlayerEntity player, Parkourability parkourability, IStamina stamina, ByteBuffer startData) {
        double ySpeed;
        float slipperiness;
        if (ParCoolConfig.Client.Booleans.EnableActionSounds.get().booleanValue()) {
            player.func_184185_a((SoundEvent)SoundEvents.WALL_JUMP.get(), 1.0f, 1.0f);
        }
        Vector3d jumpDirection = new Vector3d(startData.getDouble(), startData.getDouble(), startData.getDouble());
        Vector3d jumpMotion = jumpDirection.func_186678_a(0.59);
        Vector3d wallDirection = new Vector3d(startData.getDouble(), 0.0, startData.getDouble());
        Vector3d motion = player.func_213322_ci();
        BlockPos leanedBlock = new BlockPos(player.func_226277_ct_() + wallDirection.func_82615_a(), player.func_174813_aQ().field_72338_b + (double)player.func_213302_cg() * 0.25, player.func_226281_cx_() + wallDirection.func_82616_c());
        float f = slipperiness = player.field_70170_p.func_195588_v(leanedBlock) ? player.field_70170_p.func_180495_p(leanedBlock).getSlipperiness((IWorldReader)player.field_70170_p, leanedBlock, (Entity)player) : 0.6f;
        if ((double)slipperiness > 0.9) {
            ySpeed = motion.func_82617_b();
        } else {
            ySpeed = motion.func_82617_b() > jumpMotion.func_82617_b() ? motion.field_72448_b + jumpMotion.func_82617_b() : jumpMotion.func_82617_b();
            this.spawnJumpParticles(player, wallDirection, jumpDirection);
        }
        player.func_213293_j(motion.func_82615_a() + jumpMotion.func_82615_a(), ySpeed, motion.func_82616_c() + jumpMotion.func_82616_c());
        WallJumpAnimationType type = WallJumpAnimationType.fromCode(startData.get());
        Animation animation = Animation.get(player);
        if (animation != null) {
            switch (type) {
                case Back: {
                    animation.setAnimator(new BackwardWallJumpAnimator());
                    break;
                }
                case SwingLeftArm: {
                    animation.setAnimator(new WallJumpAnimator(false));
                    break;
                }
                case SwingRightArm: {
                    animation.setAnimator(new WallJumpAnimator(true));
                }
            }
        }
    }

    @Override
    public void onStartInOtherClient(PlayerEntity player, Parkourability parkourability, ByteBuffer startData) {
        float slipperiness;
        if (ParCoolConfig.Client.Booleans.EnableActionSounds.get().booleanValue()) {
            player.func_184185_a((SoundEvent)SoundEvents.WALL_JUMP.get(), 1.0f, 1.0f);
        }
        Vector3d jumpDirection = new Vector3d(startData.getDouble(), startData.getDouble(), startData.getDouble());
        Vector3d wallDirection = new Vector3d(startData.getDouble(), 0.0, startData.getDouble());
        BlockPos leanedBlock = new BlockPos(player.func_226277_ct_() + wallDirection.func_82615_a(), player.func_174813_aQ().field_72338_b + (double)player.func_213302_cg() * 0.25, player.func_226281_cx_() + wallDirection.func_82616_c());
        float f = slipperiness = player.field_70170_p.func_195588_v(leanedBlock) ? player.field_70170_p.func_180495_p(leanedBlock).getSlipperiness((IWorldReader)player.field_70170_p, leanedBlock, (Entity)player) : 1.0f;
        if ((double)slipperiness <= 0.9) {
            this.spawnJumpParticles(player, wallDirection, jumpDirection);
        }
        WallJumpAnimationType type = WallJumpAnimationType.fromCode(startData.get());
        Animation animation = Animation.get(player);
        if (animation != null) {
            switch (type) {
                case Back: {
                    animation.setAnimator(new BackwardWallJumpAnimator());
                    break;
                }
                case SwingLeftArm: {
                    animation.setAnimator(new WallJumpAnimator(false));
                    break;
                }
                case SwingRightArm: {
                    animation.setAnimator(new WallJumpAnimator(true));
                }
            }
        }
    }

    @Override
    public void onWorkingTickInClient(PlayerEntity player, Parkourability parkourability, IStamina stamina) {
        super.onWorkingTickInClient(player, parkourability, stamina);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnJumpParticles(PlayerEntity player, Vector3d wallDirection, Vector3d jumpDirection) {
        World level = player.field_70170_p;
        Vector3d pos = player.func_213303_ch();
        BlockPos leanedBlock = new BlockPos(pos.func_72441_c(wallDirection.func_82615_a(), (double)player.func_213302_cg() * 0.25, wallDirection.func_82616_c()));
        if (!level.func_195588_v(leanedBlock)) {
            return;
        }
        float width = player.func_213311_cf();
        BlockState blockstate = level.func_180495_p(leanedBlock);
        Vector3d horizontalJumpDirection = jumpDirection.func_216372_d(1.0, 0.0, 1.0).func_72432_b();
        wallDirection = wallDirection.func_72432_b();
        Vector3d orthogonalToWallVec = wallDirection.func_178785_b(1.5707964f).func_72432_b();
        Vector3d differenceVec = new Vector3d(-wallDirection.func_82615_a() * horizontalJumpDirection.func_82615_a() - wallDirection.func_82616_c() * horizontalJumpDirection.func_82616_c(), 0.0, wallDirection.func_82616_c() * horizontalJumpDirection.func_82615_a() - wallDirection.func_82615_a() * horizontalJumpDirection.func_82616_c()).func_216372_d(1.0, 0.0, -1.0).func_72432_b();
        Vector3d particleBaseDirection = new Vector3d(-wallDirection.func_82615_a() * differenceVec.func_82615_a() + wallDirection.func_82616_c() * differenceVec.func_82616_c(), 0.0, -wallDirection.func_82615_a() * differenceVec.func_82616_c() - wallDirection.func_82616_c() * differenceVec.func_82615_a());
        if (blockstate.func_185901_i() != BlockRenderType.INVISIBLE) {
            for (int i = 0; i < 10; ++i) {
                Vector3d particlePos = new Vector3d(pos.func_82615_a() + (wallDirection.func_82615_a() * 0.4 + orthogonalToWallVec.func_82615_a() * (player.func_70681_au().nextDouble() - 0.5)) * (double)width, pos.func_82617_b() + 0.1 + 0.3 * player.func_70681_au().nextDouble(), pos.func_82616_c() + (wallDirection.func_82616_c() * 0.4 + orthogonalToWallVec.func_82616_c() * (player.func_70681_au().nextDouble() - 0.5)) * (double)width);
                Vector3d particleSpeed = particleBaseDirection.func_178785_b((float)(0.6283185307179586 * (player.func_70681_au().nextDouble() - 0.5))).func_186678_a(3.0 + 9.0 * player.func_70681_au().nextDouble()).func_72441_c(0.0, -jumpDirection.func_82617_b() * 3.0 * player.func_70681_au().nextDouble(), 0.0);
                level.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, blockstate).setPos(leanedBlock), particlePos.func_82615_a(), particlePos.func_82617_b(), particlePos.func_82616_c(), particleSpeed.func_82615_a(), particleSpeed.func_82617_b(), particleSpeed.func_82616_c());
            }
        }
    }

    private static enum WallJumpAnimationType {
        Back,
        SwingRightArm,
        SwingLeftArm;


        public byte getCode() {
            return (byte)this.ordinal();
        }

        public static WallJumpAnimationType fromCode(byte code) {
            return WallJumpAnimationType.values()[code];
        }
    }
}

