/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.action.impl;

import com.alrex.parcool.client.animation.impl.WallSlideAnimator;
import com.alrex.parcool.client.input.KeyBindings;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.StaminaConsumeTiming;
import com.alrex.parcool.common.action.impl.ClingToCliff;
import com.alrex.parcool.common.action.impl.Dive;
import com.alrex.parcool.common.action.impl.Dodge;
import com.alrex.parcool.common.action.impl.FastRun;
import com.alrex.parcool.common.capability.Animation;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.common.damage.DamageSources;
import com.alrex.parcool.utilities.WorldUtil;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class WallSlide
extends Action {
    private Vector3d leanedWallDirection = null;
    private byte particleSpawnCoolTime = 0;
    private double startYSpeed = 0.0;
    private int damageCount = 0;
    private int takenDamageCount = 0;
    private byte damageCoolTime = 0;

    @Nullable
    public Vector3d getLeanedWallDirection() {
        return this.leanedWallDirection;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canStart(PlayerEntity player, Parkourability parkourability, IStamina stamina, ByteBuffer startInfo) {
        startInfo.putDouble(Math.abs(player.func_213322_ci().func_82617_b()));
        return this.canContinue(player, parkourability, stamina);
    }

    @Override
    public boolean canContinue(PlayerEntity player, Parkourability parkourability, IStamina stamina) {
        Vector3d wall = WorldUtil.getWall((LivingEntity)player);
        return wall != null && !player.func_233570_aj_() && !parkourability.get(FastRun.class).isDoing() && !parkourability.get(Dodge.class).isDoing() && !player.field_71075_bZ.field_75100_b && player.func_213322_ci().func_82617_b() <= 0.0 && KeyBindings.getKeyWallSlide().func_151470_d() && !stamina.isExhausted() && !parkourability.get(Dive.class).isDoing() && !parkourability.get(ClingToCliff.class).isDoing() && parkourability.get(ClingToCliff.class).getNotDoingTick() > 12;
    }

    @Override
    public void onStart(PlayerEntity player, Parkourability parkourability) {
        this.particleSpawnCoolTime = 0;
    }

    @Override
    public void onStartInServer(PlayerEntity player, Parkourability parkourability, ByteBuffer startData) {
        this.startYSpeed = startData.getDouble();
        this.damageCount = (int)(5.5 * (this.startYSpeed - 1.0) / (double)player.func_213302_cg());
        this.takenDamageCount = 0;
        this.damageCoolTime = 0;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onWorkingTickInClient(PlayerEntity player, Parkourability parkourability, IStamina stamina) {
        Animation animation = Animation.get(player);
        if (animation != null && !animation.hasAnimator()) {
            animation.setAnimator(new WallSlideAnimator());
        }
        this.particleSpawnCoolTime = (byte)(this.particleSpawnCoolTime - 1);
        if (this.particleSpawnCoolTime <= 0) {
            this.particleSpawnCoolTime = (byte)2;
            this.spawnSlideParticle(player);
        }
    }

    @Override
    public StaminaConsumeTiming getStaminaConsumeTiming() {
        return StaminaConsumeTiming.OnWorking;
    }

    @Override
    public void onWorkingTick(PlayerEntity player, Parkourability parkourability, IStamina stamina) {
        this.leanedWallDirection = WorldUtil.getWall((LivingEntity)player);
        if (this.leanedWallDirection != null) {
            BlockPos leanedBlock = new BlockPos(player.func_226277_ct_() + this.leanedWallDirection.func_82615_a(), player.func_174813_aQ().field_72338_b + (double)player.func_213302_cg() * 0.75, player.func_226281_cx_() + this.leanedWallDirection.func_82616_c());
            if (!player.field_70170_p.func_195588_v(leanedBlock)) {
                return;
            }
            float slipperiness = player.field_70170_p.func_180495_p(leanedBlock).getSlipperiness((IWorldReader)player.field_70170_p, leanedBlock, (Entity)player);
            slipperiness = (float)Math.sqrt(slipperiness);
            player.field_70143_R *= slipperiness;
            player.func_213317_d(player.func_213322_ci().func_216372_d(0.8, (double)slipperiness, 0.8));
        }
    }

    @Override
    public void onWorkingTickInServer(PlayerEntity player, Parkourability parkourability, IStamina stamina) {
        if (this.damageCoolTime <= 0 && this.damageCount > this.takenDamageCount++) {
            int invulnerableTime = player.field_70172_ad;
            this.damageCoolTime = 1;
            player.field_70172_ad = 0;
            player.func_70097_a(DamageSources.WALL_SLIDE, 0.3f);
            player.field_70172_ad = invulnerableTime;
        } else {
            this.damageCoolTime = (byte)(this.damageCoolTime - 1);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnSlideParticle(PlayerEntity player) {
        if (this.leanedWallDirection == null) {
            return;
        }
        if (player.func_70681_au().nextBoolean()) {
            return;
        }
        World level = player.field_70170_p;
        Vector3d pos = player.func_213303_ch();
        BlockPos leanedBlock = new BlockPos(pos.func_72441_c(this.leanedWallDirection.func_82615_a(), (double)player.func_213302_cg() * 0.25, this.leanedWallDirection.func_82616_c()));
        if (!level.func_195588_v(leanedBlock)) {
            return;
        }
        float width = player.func_213311_cf();
        BlockState blockstate = level.func_180495_p(leanedBlock);
        Vector3d normalizedWallVec = this.leanedWallDirection.func_72432_b();
        Vector3d orthogonalToWallVec = normalizedWallVec.func_178785_b(1.5707964f);
        if (blockstate.func_185901_i() != BlockRenderType.INVISIBLE) {
            Vector3d particlePos = new Vector3d(pos.func_82615_a() + (normalizedWallVec.func_82615_a() * 0.4 + orthogonalToWallVec.func_82615_a() * (player.func_70681_au().nextDouble() - 0.5)) * (double)width, pos.func_82617_b() + (double)player.func_213302_cg() - 0.2 + 0.3 * player.func_70681_au().nextDouble(), pos.func_82616_c() + (normalizedWallVec.func_82616_c() * 0.4 + orthogonalToWallVec.func_82616_c() * (player.func_70681_au().nextDouble() - 0.5)) * (double)width);
            Vector3d particleSpeed = normalizedWallVec.func_216371_e().func_178785_b((float)(0.3141592653589793 * (player.func_70681_au().nextDouble() - 0.5))).func_186678_a(0.05).func_72441_c(0.0, -0.5 - player.func_70681_au().nextDouble(), 0.0);
            level.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, blockstate).setPos(leanedBlock), particlePos.func_82615_a(), particlePos.func_82617_b(), particlePos.func_82616_c(), particleSpeed.func_82615_a(), particleSpeed.func_82617_b(), particleSpeed.func_82616_c());
        }
    }
}

