/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.capability;

import com.alrex.parcool.api.unstable.animation.AnimationOption;
import com.alrex.parcool.api.unstable.animation.AnimationPart;
import com.alrex.parcool.api.unstable.animation.ParCoolAnimationInfoEvent;
import com.alrex.parcool.client.animation.Animator;
import com.alrex.parcool.client.animation.PassiveCustomAnimation;
import com.alrex.parcool.client.animation.PlayerModelRotator;
import com.alrex.parcool.client.animation.PlayerModelTransformer;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.common.capability.capabilities.Capabilities;
import com.alrex.parcool.config.ParCoolConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;

@OnlyIn(value=Dist.CLIENT)
public class Animation {
    private Animator animator = null;
    private AnimationOption option = new AnimationOption();
    private final PassiveCustomAnimation passiveAnimation = new PassiveCustomAnimation();

    public static Animation get(PlayerEntity player) {
        LazyOptional optional = player.getCapability(Capabilities.ANIMATION_CAPABILITY);
        if (!optional.isPresent()) {
            return null;
        }
        return (Animation)optional.orElseThrow(IllegalStateException::new);
    }

    public void setAnimator(Animator animator) {
        if (!ParCoolConfig.Client.Booleans.EnableAnimation.get().booleanValue()) {
            return;
        }
        if (!((Boolean)ParCoolConfig.Client.canAnimate(animator.getClass()).get()).booleanValue()) {
            return;
        }
        this.animator = animator;
    }

    public boolean animatePre(PlayerEntity player, PlayerModelTransformer modelTransformer) {
        if (this.animator == null) {
            return false;
        }
        Parkourability parkourability = Parkourability.get(player);
        modelTransformer.setOption(this.option);
        if (this.option.isAnimationCanceled()) {
            return false;
        }
        return this.animator.animatePre(player, parkourability, modelTransformer);
    }

    public void animatePost(PlayerEntity player, PlayerModelTransformer modelTransformer) {
        Parkourability parkourability = Parkourability.get(player);
        if (parkourability == null) {
            return;
        }
        if (this.animator == null) {
            this.passiveAnimation.animate(player, parkourability, modelTransformer);
            return;
        }
        if (this.option.isAnimationCanceled()) {
            return;
        }
        this.animator.animatePost(player, parkourability, modelTransformer);
    }

    public boolean rotatePre(AbstractClientPlayerEntity player, PlayerModelRotator rotator) {
        Parkourability parkourability = Parkourability.get((PlayerEntity)player);
        if (parkourability == null || this.animator == null) {
            return false;
        }
        if (this.option.isAnimationCanceled() || this.option.isCanceled(AnimationPart.ROTATION)) {
            return false;
        }
        return this.animator.rotatePre((PlayerEntity)player, parkourability, rotator);
    }

    public void rotatePost(AbstractClientPlayerEntity player, PlayerModelRotator rotator) {
        Parkourability parkourability = Parkourability.get((PlayerEntity)player);
        if (parkourability == null) {
            return;
        }
        if (this.animator == null) {
            this.passiveAnimation.rotate((PlayerEntity)player, parkourability, rotator);
            return;
        }
        if (this.option.isAnimationCanceled() || this.option.isCanceled(AnimationPart.ROTATION)) {
            return;
        }
        this.animator.rotatePost((PlayerEntity)player, parkourability, rotator);
    }

    public void cameraSetup(EntityViewRenderEvent.CameraSetup event, ClientPlayerEntity player, Parkourability parkourability) {
        if (this.animator == null) {
            return;
        }
        if (player.func_175144_cb() && Minecraft.func_71410_x().field_71474_y.func_243230_g().func_243192_a() && !ParCoolConfig.Client.Booleans.EnableFPVAnimation.get().booleanValue()) {
            return;
        }
        if (this.option.isCanceled(AnimationPart.CAMERA)) {
            return;
        }
        this.animator.onCameraSetUp(event, (PlayerEntity)player, parkourability);
    }

    public void tick(AbstractClientPlayerEntity player, Parkourability parkourability) {
        this.passiveAnimation.tick((PlayerEntity)player, parkourability);
        if (this.animator != null) {
            this.animator.tick((PlayerEntity)player);
            if (this.animator.shouldRemoved((PlayerEntity)player, parkourability)) {
                this.animator = null;
            }
        }
        ParCoolAnimationInfoEvent animationEvent = new ParCoolAnimationInfoEvent(player, this.animator);
        MinecraftForge.EVENT_BUS.post((Event)animationEvent);
        this.option = animationEvent.getOption();
    }

    public void onRenderTick(TickEvent.RenderTickEvent event, PlayerEntity player, Parkourability parkourability) {
        if (this.animator != null) {
            this.animator.onRenderTick(event, player, parkourability);
        }
    }

    public boolean hasAnimator() {
        return this.animator != null;
    }

    public void removeAnimator() {
        this.animator = null;
    }
}

