/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.capability;

import com.alrex.parcool.common.capability.capabilities.Capabilities;
import com.alrex.parcool.common.capability.stamina.HungerStamina;
import com.alrex.parcool.common.capability.stamina.Stamina;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.common.util.LazyOptional;

public interface IStamina {
    @Nullable
    public static IStamina get(PlayerEntity player) {
        LazyOptional optional = player.getCapability(Capabilities.STAMINA_CAPABILITY);
        return (IStamina)optional.orElse(null);
    }

    public int getActualMaxStamina();

    public int get();

    public int getOldValue();

    public void consume(int var1);

    public void recover(int var1);

    public boolean isExhausted();

    public void setExhaustion(boolean var1);

    public void tick();

    public void set(int var1);

    default public boolean wantToConsumeOnServer() {
        return false;
    }

    default public int getRequestedValueConsumedOnServer() {
        return 0;
    }

    public static enum Type {
        Default(Stamina.class, Stamina::new, null),
        Hunger(HungerStamina.class, HungerStamina::new, HungerStamina::consumeOnServer);

        private final Function<PlayerEntity, IStamina> constructor;
        private final Class<? extends IStamina> clazz;
        @Nullable
        private final BiConsumer<ServerPlayerEntity, Integer> serverStaminaHandler;

        private Type(Class<? extends IStamina> clazz, Function<PlayerEntity, IStamina> constructor, BiConsumer<ServerPlayerEntity, Integer> serverStaminaHandler) {
            this.constructor = constructor;
            this.clazz = clazz;
            this.serverStaminaHandler = serverStaminaHandler;
        }

        public IStamina newInstance(PlayerEntity player) {
            return this.constructor.apply(player);
        }

        public void handleConsumeOnServer(ServerPlayerEntity player, int value) {
            if (this.serverStaminaHandler != null) {
                this.serverStaminaHandler.accept(player, value);
            }
        }

        public static Type getFromInstance(IStamina stamina) {
            for (Type type : Type.values()) {
                if (!type.clazz.isAssignableFrom(stamina.getClass())) continue;
                return type;
            }
            return null;
        }
    }
}

