/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.capability;

import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.ActionList;
import com.alrex.parcool.common.action.AdditionalProperties;
import com.alrex.parcool.common.action.CancelMarks;
import com.alrex.parcool.common.capability.capabilities.Capabilities;
import com.alrex.parcool.common.info.ActionInfo;
import com.alrex.parcool.common.info.ClientSetting;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.common.util.LazyOptional;

public class Parkourability {
    private final ActionInfo info;
    private final AdditionalProperties properties = new AdditionalProperties();
    private final CancelMarks cancelMarks = new CancelMarks();
    private final List<Action> actions = ActionList.constructActionsList();
    private final HashMap<Class<? extends Action>, Action> actionsMap = new HashMap((int)((double)this.actions.size() * 1.5));

    @Nullable
    public static Parkourability get(PlayerEntity player) {
        LazyOptional optional = player.getCapability(Capabilities.PARKOURABILITY_CAPABILITY);
        return (Parkourability)optional.orElse(null);
    }

    public Parkourability() {
        for (Action action : this.actions) {
            this.actionsMap.put(action.getClass(), action);
        }
        this.info = new ActionInfo();
    }

    public <T extends Action> T get(Class<T> action) {
        Action value = this.actionsMap.getOrDefault(action, null);
        if (value == null) {
            throw new IllegalArgumentException("The Action instance is not registered:" + action.getSimpleName());
        }
        return (T)value;
    }

    public short getActionID(Action instance) {
        return ActionList.getIndexOf(instance.getClass());
    }

    @Nullable
    public Action getActionFromID(short id) {
        if (0 <= id && id < this.actions.size()) {
            return this.actions.get(id);
        }
        return null;
    }

    public AdditionalProperties getAdditionalProperties() {
        return this.properties;
    }

    public CancelMarks getCancelMarks() {
        return this.cancelMarks;
    }

    public ActionInfo getActionInfo() {
        return this.info;
    }

    public ClientSetting getClientInfo() {
        return this.info.getClientSetting();
    }

    public List<Action> getList() {
        return this.actions;
    }

    public void CopyFrom(Parkourability original) {
        this.getActionInfo().setClientSetting(original.getActionInfo().getClientSetting());
        this.getActionInfo().setServerLimitation(original.getActionInfo().getServerLimitation());
    }
}

