/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.capability.stamina;

import com.alrex.parcool.api.Effects;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.Parkourability;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.potion.Effect;

public class HungerStamina
implements IStamina {
    private final PlayerEntity player;
    private float consumedBuffer = 0.0f;

    public HungerStamina(PlayerEntity player) {
        this.player = player;
    }

    @Override
    public int getActualMaxStamina() {
        return 20;
    }

    @Override
    public int get() {
        return this.player.func_71024_bL().func_75116_a();
    }

    @Override
    public int getOldValue() {
        return this.get();
    }

    @Override
    public void consume(int value) {
        Parkourability parkourability = Parkourability.get(this.player);
        if (parkourability == null) {
            return;
        }
        if (this.isExhausted() || parkourability.getActionInfo().isStaminaInfinite(this.player.func_175149_v() || this.player.func_184812_l_()) || this.player.func_70644_a((Effect)Effects.INEXHAUSTIBLE.get())) {
            return;
        }
        this.consumedBuffer += (float)value / 150.0f;
    }

    @Override
    public void recover(int value) {
    }

    @Override
    public boolean isExhausted() {
        return this.get() <= 6;
    }

    @Override
    public void setExhaustion(boolean value) {
    }

    @Override
    public void tick() {
    }

    @Override
    public void set(int value) {
    }

    @Override
    public boolean wantToConsumeOnServer() {
        return this.consumedBuffer != 0.0f;
    }

    @Override
    public int getRequestedValueConsumedOnServer() {
        int neededValue = (int)(this.consumedBuffer * 10000.0f);
        this.consumedBuffer = 0.0f;
        return neededValue;
    }

    public static void consumeOnServer(ServerPlayerEntity player, int value) {
        player.func_71020_j((float)value / 10000.0f);
    }
}

