/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.capability.stamina;

import com.alrex.parcool.api.Attributes;
import com.alrex.parcool.api.Effects;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.Parkourability;
import javax.annotation.Nullable;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;

public class Stamina
implements IStamina {
    @Nullable
    private final PlayerEntity player;
    private int stamina = 0;
    private int staminaOld = 0;
    private boolean exhausted = false;
    private int recoverCoolTime = 0;

    public Stamina(@Nullable PlayerEntity player) {
        this.player = player;
        if (player != null && player.func_175144_cb()) {
            this.set(Integer.MAX_VALUE);
        }
    }

    public Stamina() {
        this.player = null;
    }

    @Override
    public int getActualMaxStamina() {
        if (this.player == null) {
            return 1;
        }
        Parkourability parkourability = Parkourability.get(this.player);
        if (parkourability == null) {
            return 1;
        }
        ModifiableAttributeInstance attr = this.player.func_110148_a((Attribute)Attributes.MAX_STAMINA.get());
        if (attr == null) {
            return 1;
        }
        return Math.min((int)attr.func_111126_e(), parkourability.getActionInfo().getMaxStaminaLimit());
    }

    @Override
    public int get() {
        return this.stamina;
    }

    @Override
    public int getOldValue() {
        return this.staminaOld;
    }

    @Override
    public void consume(int value) {
        if (this.player == null) {
            return;
        }
        Parkourability parkourability = Parkourability.get(this.player);
        if (parkourability == null) {
            return;
        }
        if (this.exhausted || parkourability.getActionInfo().isStaminaInfinite(this.player.func_175149_v() || this.player.func_184812_l_()) || this.player.func_70644_a((Effect)Effects.INEXHAUSTIBLE.get())) {
            return;
        }
        this.recoverCoolTime = 30;
        this.set(this.stamina - value);
        if (this.stamina == 0) {
            this.exhausted = true;
        }
    }

    @Override
    public void recover(int value) {
        this.set(this.stamina + value);
        if (this.stamina == this.getActualMaxStamina()) {
            this.exhausted = false;
        }
    }

    @Override
    public boolean isExhausted() {
        return this.exhausted;
    }

    @Override
    public void setExhaustion(boolean value) {
        this.exhausted = value;
    }

    @Override
    public void tick() {
        this.staminaOld = this.stamina;
        if (this.recoverCoolTime > 0) {
            --this.recoverCoolTime;
        }
        if (this.recoverCoolTime <= 0) {
            if (this.player == null) {
                return;
            }
            Parkourability parkourability = Parkourability.get(this.player);
            if (parkourability == null) {
                return;
            }
            ModifiableAttributeInstance attr = this.player.func_110148_a((Attribute)Attributes.STAMINA_RECOVERY.get());
            if (attr == null) {
                return;
            }
            if (this.player.func_233570_aj_()) {
                this.recover(Math.min((int)attr.func_111126_e(), parkourability.getActionInfo().getStaminaRecoveryLimit()));
            } else {
                this.recover(Math.min((int)attr.func_111126_e(), parkourability.getActionInfo().getStaminaRecoveryLimit()) / 5);
            }
        }
    }

    @Override
    public void set(int value) {
        this.stamina = Math.min(value, this.getActualMaxStamina());
        if (this.stamina <= 0) {
            this.stamina = 0;
        }
    }
}

