/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.handlers;

import com.alrex.parcool.common.action.impl.BreakfallReady;
import com.alrex.parcool.common.action.impl.ChargeJump;
import com.alrex.parcool.common.action.impl.Roll;
import com.alrex.parcool.common.action.impl.Tap;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.common.network.StartBreakfallMessage;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class PlayerFallHandler {
    @SubscribeEvent
    public static void onFall(LivingFallEvent event) {
        if (event.getEntity() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getEntity();
            Parkourability parkourability = Parkourability.get((PlayerEntity)player);
            if (parkourability == null) {
                return;
            }
            if (parkourability.get(BreakfallReady.class).isDoing() && (parkourability.getActionInfo().can(Tap.class) || parkourability.getActionInfo().can(Roll.class))) {
                boolean justTime = parkourability.get(BreakfallReady.class).getDoingTick() < 5;
                float distance = event.getDistance();
                if (distance > 2.0f) {
                    StartBreakfallMessage.send(player, justTime);
                }
                if (distance < 6.0f || justTime && distance < 8.0f) {
                    event.setCanceled(true);
                } else {
                    event.setDamageMultiplier(event.getDamageMultiplier() * (justTime ? 0.4f : 0.6f));
                }
            }
        } else if (event.getEntity() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntity();
            if (!player.func_175144_cb()) {
                return;
            }
            Parkourability parkourability = Parkourability.get(player);
            if (parkourability == null) {
                return;
            }
            if (parkourability.getAdditionalProperties().getNotLandingTick() > 5 && event.getDistance() < 0.4f) {
                parkourability.get(ChargeJump.class).onLand(player, parkourability);
            }
        }
    }
}

